// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// MountPoint MountPoint represents a mount point configuration inside the container.
//
// This is used for reporting the mountpoints in use by a container.
//
// swagger:model MountPoint
type MountPoint struct {

	// destination
	Destination string `json:"Destination,omitempty"`

	// driver
	Driver string `json:"Driver,omitempty"`

	// mode
	Mode string `json:"Mode,omitempty"`

	// name
	Name string `json:"Name,omitempty"`

	// propagation
	Propagation Propagation `json:"Propagation,omitempty"`

	// r w
	RW bool `json:"RW,omitempty"`

	// source
	Source string `json:"Source,omitempty"`

	// type
	Type Type `json:"Type,omitempty"`
}

// Validate validates this mount point
func (m *MountPoint) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePropagation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MountPoint) validatePropagation(formats strfmt.Registry) error {
	if swag.IsZero(m.Propagation) { // not required
		return nil
	}

	if err := m.Propagation.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("Propagation")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("Propagation")
		}
		return err
	}

	return nil
}

func (m *MountPoint) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	if err := m.Type.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("Type")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("Type")
		}
		return err
	}

	return nil
}

// ContextValidate validate this mount point based on the context it is used
func (m *MountPoint) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePropagation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MountPoint) contextValidatePropagation(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Propagation.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("Propagation")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("Propagation")
		}
		return err
	}

	return nil
}

func (m *MountPoint) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Type.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("Type")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("Type")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MountPoint) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MountPoint) UnmarshalBinary(b []byte) error {
	var res MountPoint
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
