// Code generated by go-swagger; DO NOT EDIT.

package images_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ImageCreateReader is a Reader for the ImageCreate structure.
type ImageCreateReader struct {
	formats strfmt.Registry
	writer  io.Writer
}

// ReadResponse reads a server response into the received o.
func (o *ImageCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewImageCreateOK(o.writer)
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewImageCreateNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewImageCreateInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewImageCreateOK creates a ImageCreateOK with default headers values
func NewImageCreateOK(writer io.Writer) *ImageCreateOK {
	return &ImageCreateOK{

		Payload: writer,
	}
}

/*
ImageCreateOK describes a response with status code 200, with default header values.

no error
*/
type ImageCreateOK struct {
	Payload io.Writer
}

// IsSuccess returns true when this image create o k response has a 2xx status code
func (o *ImageCreateOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this image create o k response has a 3xx status code
func (o *ImageCreateOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image create o k response has a 4xx status code
func (o *ImageCreateOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this image create o k response has a 5xx status code
func (o *ImageCreateOK) IsServerError() bool {
	return false
}

// IsCode returns true when this image create o k response a status code equal to that given
func (o *ImageCreateOK) IsCode(code int) bool {
	return code == 200
}

func (o *ImageCreateOK) Error() string {
	return fmt.Sprintf("[POST /images/create][%d] imageCreateOK  %+v", 200, o.Payload)
}

func (o *ImageCreateOK) String() string {
	return fmt.Sprintf("[POST /images/create][%d] imageCreateOK  %+v", 200, o.Payload)
}

func (o *ImageCreateOK) GetPayload() io.Writer {
	return o.Payload
}

func (o *ImageCreateOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImageCreateNotFound creates a ImageCreateNotFound with default headers values
func NewImageCreateNotFound() *ImageCreateNotFound {
	return &ImageCreateNotFound{}
}

/*
ImageCreateNotFound describes a response with status code 404, with default header values.

No such image
*/
type ImageCreateNotFound struct {
	Payload *ImageCreateNotFoundBody
}

// IsSuccess returns true when this image create not found response has a 2xx status code
func (o *ImageCreateNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image create not found response has a 3xx status code
func (o *ImageCreateNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image create not found response has a 4xx status code
func (o *ImageCreateNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this image create not found response has a 5xx status code
func (o *ImageCreateNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this image create not found response a status code equal to that given
func (o *ImageCreateNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ImageCreateNotFound) Error() string {
	return fmt.Sprintf("[POST /images/create][%d] imageCreateNotFound  %+v", 404, o.Payload)
}

func (o *ImageCreateNotFound) String() string {
	return fmt.Sprintf("[POST /images/create][%d] imageCreateNotFound  %+v", 404, o.Payload)
}

func (o *ImageCreateNotFound) GetPayload() *ImageCreateNotFoundBody {
	return o.Payload
}

func (o *ImageCreateNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageCreateNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImageCreateInternalServerError creates a ImageCreateInternalServerError with default headers values
func NewImageCreateInternalServerError() *ImageCreateInternalServerError {
	return &ImageCreateInternalServerError{}
}

/*
ImageCreateInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ImageCreateInternalServerError struct {
	Payload *ImageCreateInternalServerErrorBody
}

// IsSuccess returns true when this image create internal server error response has a 2xx status code
func (o *ImageCreateInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image create internal server error response has a 3xx status code
func (o *ImageCreateInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image create internal server error response has a 4xx status code
func (o *ImageCreateInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this image create internal server error response has a 5xx status code
func (o *ImageCreateInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this image create internal server error response a status code equal to that given
func (o *ImageCreateInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ImageCreateInternalServerError) Error() string {
	return fmt.Sprintf("[POST /images/create][%d] imageCreateInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageCreateInternalServerError) String() string {
	return fmt.Sprintf("[POST /images/create][%d] imageCreateInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageCreateInternalServerError) GetPayload() *ImageCreateInternalServerErrorBody {
	return o.Payload
}

func (o *ImageCreateInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageCreateInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ImageCreateInternalServerErrorBody image create internal server error body
swagger:model ImageCreateInternalServerErrorBody
*/
type ImageCreateInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image create internal server error body
func (o *ImageCreateInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image create internal server error body based on context it is used
func (o *ImageCreateInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageCreateInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageCreateInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ImageCreateInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ImageCreateNotFoundBody image create not found body
swagger:model ImageCreateNotFoundBody
*/
type ImageCreateNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image create not found body
func (o *ImageCreateNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image create not found body based on context it is used
func (o *ImageCreateNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageCreateNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageCreateNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ImageCreateNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
