// Code generated by go-swagger; DO NOT EDIT.

package secrets_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// SecretCreateReader is a Reader for the SecretCreate structure.
type SecretCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecretCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewSecretCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 409:
		result := NewSecretCreateConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewSecretCreateInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewSecretCreateCreated creates a SecretCreateCreated with default headers values
func NewSecretCreateCreated() *SecretCreateCreated {
	return &SecretCreateCreated{}
}

/*
SecretCreateCreated describes a response with status code 201, with default header values.

Secret create response
*/
type SecretCreateCreated struct {
	Payload *SecretCreateCreatedBody
}

// IsSuccess returns true when this secret create created response has a 2xx status code
func (o *SecretCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this secret create created response has a 3xx status code
func (o *SecretCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this secret create created response has a 4xx status code
func (o *SecretCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this secret create created response has a 5xx status code
func (o *SecretCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this secret create created response a status code equal to that given
func (o *SecretCreateCreated) IsCode(code int) bool {
	return code == 201
}

func (o *SecretCreateCreated) Error() string {
	return fmt.Sprintf("[POST /secrets/create][%d] secretCreateCreated  %+v", 201, o.Payload)
}

func (o *SecretCreateCreated) String() string {
	return fmt.Sprintf("[POST /secrets/create][%d] secretCreateCreated  %+v", 201, o.Payload)
}

func (o *SecretCreateCreated) GetPayload() *SecretCreateCreatedBody {
	return o.Payload
}

func (o *SecretCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(SecretCreateCreatedBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecretCreateConflict creates a SecretCreateConflict with default headers values
func NewSecretCreateConflict() *SecretCreateConflict {
	return &SecretCreateConflict{}
}

/*
SecretCreateConflict describes a response with status code 409, with default header values.

Secret in use
*/
type SecretCreateConflict struct {
	Payload *SecretCreateConflictBody
}

// IsSuccess returns true when this secret create conflict response has a 2xx status code
func (o *SecretCreateConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this secret create conflict response has a 3xx status code
func (o *SecretCreateConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this secret create conflict response has a 4xx status code
func (o *SecretCreateConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this secret create conflict response has a 5xx status code
func (o *SecretCreateConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this secret create conflict response a status code equal to that given
func (o *SecretCreateConflict) IsCode(code int) bool {
	return code == 409
}

func (o *SecretCreateConflict) Error() string {
	return fmt.Sprintf("[POST /secrets/create][%d] secretCreateConflict  %+v", 409, o.Payload)
}

func (o *SecretCreateConflict) String() string {
	return fmt.Sprintf("[POST /secrets/create][%d] secretCreateConflict  %+v", 409, o.Payload)
}

func (o *SecretCreateConflict) GetPayload() *SecretCreateConflictBody {
	return o.Payload
}

func (o *SecretCreateConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(SecretCreateConflictBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecretCreateInternalServerError creates a SecretCreateInternalServerError with default headers values
func NewSecretCreateInternalServerError() *SecretCreateInternalServerError {
	return &SecretCreateInternalServerError{}
}

/*
SecretCreateInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type SecretCreateInternalServerError struct {
	Payload *SecretCreateInternalServerErrorBody
}

// IsSuccess returns true when this secret create internal server error response has a 2xx status code
func (o *SecretCreateInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this secret create internal server error response has a 3xx status code
func (o *SecretCreateInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this secret create internal server error response has a 4xx status code
func (o *SecretCreateInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this secret create internal server error response has a 5xx status code
func (o *SecretCreateInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this secret create internal server error response a status code equal to that given
func (o *SecretCreateInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *SecretCreateInternalServerError) Error() string {
	return fmt.Sprintf("[POST /secrets/create][%d] secretCreateInternalServerError  %+v", 500, o.Payload)
}

func (o *SecretCreateInternalServerError) String() string {
	return fmt.Sprintf("[POST /secrets/create][%d] secretCreateInternalServerError  %+v", 500, o.Payload)
}

func (o *SecretCreateInternalServerError) GetPayload() *SecretCreateInternalServerErrorBody {
	return o.Payload
}

func (o *SecretCreateInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(SecretCreateInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SecretCreateConflictBody secret create conflict body
swagger:model SecretCreateConflictBody
*/
type SecretCreateConflictBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this secret create conflict body
func (o *SecretCreateConflictBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this secret create conflict body based on context it is used
func (o *SecretCreateConflictBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *SecretCreateConflictBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecretCreateConflictBody) UnmarshalBinary(b []byte) error {
	var res SecretCreateConflictBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecretCreateCreatedBody secret create created body
swagger:model SecretCreateCreatedBody
*/
type SecretCreateCreatedBody struct {

	// ID
	ID string `json:"ID,omitempty"`
}

// Validate validates this secret create created body
func (o *SecretCreateCreatedBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this secret create created body based on context it is used
func (o *SecretCreateCreatedBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *SecretCreateCreatedBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecretCreateCreatedBody) UnmarshalBinary(b []byte) error {
	var res SecretCreateCreatedBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecretCreateInternalServerErrorBody secret create internal server error body
swagger:model SecretCreateInternalServerErrorBody
*/
type SecretCreateInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this secret create internal server error body
func (o *SecretCreateInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this secret create internal server error body based on context it is used
func (o *SecretCreateInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *SecretCreateInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecretCreateInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res SecretCreateInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
