// Code generated by go-swagger; DO NOT EDIT.

package containers_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ImageCommitReader is a Reader for the ImageCommit structure.
type ImageCommitReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ImageCommitReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewImageCommitCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewImageCommitNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewImageCommitInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewImageCommitCreated creates a ImageCommitCreated with default headers values
func NewImageCommitCreated() *ImageCommitCreated {
	return &ImageCommitCreated{}
}

/*
ImageCommitCreated describes a response with status code 201, with default header values.

no error
*/
type ImageCommitCreated struct {
}

// IsSuccess returns true when this image commit created response has a 2xx status code
func (o *ImageCommitCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this image commit created response has a 3xx status code
func (o *ImageCommitCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image commit created response has a 4xx status code
func (o *ImageCommitCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this image commit created response has a 5xx status code
func (o *ImageCommitCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this image commit created response a status code equal to that given
func (o *ImageCommitCreated) IsCode(code int) bool {
	return code == 201
}

func (o *ImageCommitCreated) Error() string {
	return fmt.Sprintf("[POST /commit][%d] imageCommitCreated ", 201)
}

func (o *ImageCommitCreated) String() string {
	return fmt.Sprintf("[POST /commit][%d] imageCommitCreated ", 201)
}

func (o *ImageCommitCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewImageCommitNotFound creates a ImageCommitNotFound with default headers values
func NewImageCommitNotFound() *ImageCommitNotFound {
	return &ImageCommitNotFound{}
}

/*
ImageCommitNotFound describes a response with status code 404, with default header values.

No such image
*/
type ImageCommitNotFound struct {
	Payload *ImageCommitNotFoundBody
}

// IsSuccess returns true when this image commit not found response has a 2xx status code
func (o *ImageCommitNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image commit not found response has a 3xx status code
func (o *ImageCommitNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image commit not found response has a 4xx status code
func (o *ImageCommitNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this image commit not found response has a 5xx status code
func (o *ImageCommitNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this image commit not found response a status code equal to that given
func (o *ImageCommitNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ImageCommitNotFound) Error() string {
	return fmt.Sprintf("[POST /commit][%d] imageCommitNotFound  %+v", 404, o.Payload)
}

func (o *ImageCommitNotFound) String() string {
	return fmt.Sprintf("[POST /commit][%d] imageCommitNotFound  %+v", 404, o.Payload)
}

func (o *ImageCommitNotFound) GetPayload() *ImageCommitNotFoundBody {
	return o.Payload
}

func (o *ImageCommitNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageCommitNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImageCommitInternalServerError creates a ImageCommitInternalServerError with default headers values
func NewImageCommitInternalServerError() *ImageCommitInternalServerError {
	return &ImageCommitInternalServerError{}
}

/*
ImageCommitInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ImageCommitInternalServerError struct {
	Payload *ImageCommitInternalServerErrorBody
}

// IsSuccess returns true when this image commit internal server error response has a 2xx status code
func (o *ImageCommitInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image commit internal server error response has a 3xx status code
func (o *ImageCommitInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image commit internal server error response has a 4xx status code
func (o *ImageCommitInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this image commit internal server error response has a 5xx status code
func (o *ImageCommitInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this image commit internal server error response a status code equal to that given
func (o *ImageCommitInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ImageCommitInternalServerError) Error() string {
	return fmt.Sprintf("[POST /commit][%d] imageCommitInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageCommitInternalServerError) String() string {
	return fmt.Sprintf("[POST /commit][%d] imageCommitInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageCommitInternalServerError) GetPayload() *ImageCommitInternalServerErrorBody {
	return o.Payload
}

func (o *ImageCommitInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageCommitInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ImageCommitInternalServerErrorBody image commit internal server error body
swagger:model ImageCommitInternalServerErrorBody
*/
type ImageCommitInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image commit internal server error body
func (o *ImageCommitInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image commit internal server error body based on context it is used
func (o *ImageCommitInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageCommitInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageCommitInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ImageCommitInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ImageCommitNotFoundBody image commit not found body
swagger:model ImageCommitNotFoundBody
*/
type ImageCommitNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image commit not found body
func (o *ImageCommitNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image commit not found body based on context it is used
func (o *ImageCommitNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageCommitNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageCommitNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ImageCommitNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
