// Code generated by go-swagger; DO NOT EDIT.

package manifests

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// ManifestCreateLibpodReader is a Reader for the ManifestCreateLibpod structure.
type ManifestCreateLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ManifestCreateLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewManifestCreateLibpodCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewManifestCreateLibpodBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewManifestCreateLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewManifestCreateLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewManifestCreateLibpodCreated creates a ManifestCreateLibpodCreated with default headers values
func NewManifestCreateLibpodCreated() *ManifestCreateLibpodCreated {
	return &ManifestCreateLibpodCreated{}
}

/*
ManifestCreateLibpodCreated describes a response with status code 201, with default header values.

ManifestCreateLibpodCreated manifest create libpod created
*/
type ManifestCreateLibpodCreated struct {
	Payload *models.IDResponse
}

// IsSuccess returns true when this manifest create libpod created response has a 2xx status code
func (o *ManifestCreateLibpodCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this manifest create libpod created response has a 3xx status code
func (o *ManifestCreateLibpodCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this manifest create libpod created response has a 4xx status code
func (o *ManifestCreateLibpodCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this manifest create libpod created response has a 5xx status code
func (o *ManifestCreateLibpodCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this manifest create libpod created response a status code equal to that given
func (o *ManifestCreateLibpodCreated) IsCode(code int) bool {
	return code == 201
}

func (o *ManifestCreateLibpodCreated) Error() string {
	return fmt.Sprintf("[POST /libpod/manifests][%d] manifestCreateLibpodCreated  %+v", 201, o.Payload)
}

func (o *ManifestCreateLibpodCreated) String() string {
	return fmt.Sprintf("[POST /libpod/manifests][%d] manifestCreateLibpodCreated  %+v", 201, o.Payload)
}

func (o *ManifestCreateLibpodCreated) GetPayload() *models.IDResponse {
	return o.Payload
}

func (o *ManifestCreateLibpodCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.IDResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewManifestCreateLibpodBadRequest creates a ManifestCreateLibpodBadRequest with default headers values
func NewManifestCreateLibpodBadRequest() *ManifestCreateLibpodBadRequest {
	return &ManifestCreateLibpodBadRequest{}
}

/*
ManifestCreateLibpodBadRequest describes a response with status code 400, with default header values.

Bad parameter in request
*/
type ManifestCreateLibpodBadRequest struct {
	Payload *ManifestCreateLibpodBadRequestBody
}

// IsSuccess returns true when this manifest create libpod bad request response has a 2xx status code
func (o *ManifestCreateLibpodBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this manifest create libpod bad request response has a 3xx status code
func (o *ManifestCreateLibpodBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this manifest create libpod bad request response has a 4xx status code
func (o *ManifestCreateLibpodBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this manifest create libpod bad request response has a 5xx status code
func (o *ManifestCreateLibpodBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this manifest create libpod bad request response a status code equal to that given
func (o *ManifestCreateLibpodBadRequest) IsCode(code int) bool {
	return code == 400
}

func (o *ManifestCreateLibpodBadRequest) Error() string {
	return fmt.Sprintf("[POST /libpod/manifests][%d] manifestCreateLibpodBadRequest  %+v", 400, o.Payload)
}

func (o *ManifestCreateLibpodBadRequest) String() string {
	return fmt.Sprintf("[POST /libpod/manifests][%d] manifestCreateLibpodBadRequest  %+v", 400, o.Payload)
}

func (o *ManifestCreateLibpodBadRequest) GetPayload() *ManifestCreateLibpodBadRequestBody {
	return o.Payload
}

func (o *ManifestCreateLibpodBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ManifestCreateLibpodBadRequestBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewManifestCreateLibpodNotFound creates a ManifestCreateLibpodNotFound with default headers values
func NewManifestCreateLibpodNotFound() *ManifestCreateLibpodNotFound {
	return &ManifestCreateLibpodNotFound{}
}

/*
ManifestCreateLibpodNotFound describes a response with status code 404, with default header values.

No such image
*/
type ManifestCreateLibpodNotFound struct {
	Payload *ManifestCreateLibpodNotFoundBody
}

// IsSuccess returns true when this manifest create libpod not found response has a 2xx status code
func (o *ManifestCreateLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this manifest create libpod not found response has a 3xx status code
func (o *ManifestCreateLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this manifest create libpod not found response has a 4xx status code
func (o *ManifestCreateLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this manifest create libpod not found response has a 5xx status code
func (o *ManifestCreateLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this manifest create libpod not found response a status code equal to that given
func (o *ManifestCreateLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ManifestCreateLibpodNotFound) Error() string {
	return fmt.Sprintf("[POST /libpod/manifests][%d] manifestCreateLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ManifestCreateLibpodNotFound) String() string {
	return fmt.Sprintf("[POST /libpod/manifests][%d] manifestCreateLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ManifestCreateLibpodNotFound) GetPayload() *ManifestCreateLibpodNotFoundBody {
	return o.Payload
}

func (o *ManifestCreateLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ManifestCreateLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewManifestCreateLibpodInternalServerError creates a ManifestCreateLibpodInternalServerError with default headers values
func NewManifestCreateLibpodInternalServerError() *ManifestCreateLibpodInternalServerError {
	return &ManifestCreateLibpodInternalServerError{}
}

/*
ManifestCreateLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ManifestCreateLibpodInternalServerError struct {
	Payload *ManifestCreateLibpodInternalServerErrorBody
}

// IsSuccess returns true when this manifest create libpod internal server error response has a 2xx status code
func (o *ManifestCreateLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this manifest create libpod internal server error response has a 3xx status code
func (o *ManifestCreateLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this manifest create libpod internal server error response has a 4xx status code
func (o *ManifestCreateLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this manifest create libpod internal server error response has a 5xx status code
func (o *ManifestCreateLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this manifest create libpod internal server error response a status code equal to that given
func (o *ManifestCreateLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ManifestCreateLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[POST /libpod/manifests][%d] manifestCreateLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ManifestCreateLibpodInternalServerError) String() string {
	return fmt.Sprintf("[POST /libpod/manifests][%d] manifestCreateLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ManifestCreateLibpodInternalServerError) GetPayload() *ManifestCreateLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ManifestCreateLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ManifestCreateLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ManifestCreateLibpodBadRequestBody manifest create libpod bad request body
swagger:model ManifestCreateLibpodBadRequestBody
*/
type ManifestCreateLibpodBadRequestBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this manifest create libpod bad request body
func (o *ManifestCreateLibpodBadRequestBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this manifest create libpod bad request body based on context it is used
func (o *ManifestCreateLibpodBadRequestBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ManifestCreateLibpodBadRequestBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ManifestCreateLibpodBadRequestBody) UnmarshalBinary(b []byte) error {
	var res ManifestCreateLibpodBadRequestBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ManifestCreateLibpodInternalServerErrorBody manifest create libpod internal server error body
swagger:model ManifestCreateLibpodInternalServerErrorBody
*/
type ManifestCreateLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this manifest create libpod internal server error body
func (o *ManifestCreateLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this manifest create libpod internal server error body based on context it is used
func (o *ManifestCreateLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ManifestCreateLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ManifestCreateLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ManifestCreateLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ManifestCreateLibpodNotFoundBody manifest create libpod not found body
swagger:model ManifestCreateLibpodNotFoundBody
*/
type ManifestCreateLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this manifest create libpod not found body
func (o *ManifestCreateLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this manifest create libpod not found body based on context it is used
func (o *ManifestCreateLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ManifestCreateLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ManifestCreateLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ManifestCreateLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
