// Code generated by go-swagger; DO NOT EDIT.

package pods

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// PodStartLibpodReader is a Reader for the PodStartLibpod structure.
type PodStartLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PodStartLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPodStartLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 304:
		result := NewPodStartLibpodNotModified()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewPodStartLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewPodStartLibpodConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPodStartLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewPodStartLibpodOK creates a PodStartLibpodOK with default headers values
func NewPodStartLibpodOK() *PodStartLibpodOK {
	return &PodStartLibpodOK{}
}

/*
PodStartLibpodOK describes a response with status code 200, with default header values.

Start pod
*/
type PodStartLibpodOK struct {
	Payload *models.PodStartReport
}

// IsSuccess returns true when this pod start libpod o k response has a 2xx status code
func (o *PodStartLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this pod start libpod o k response has a 3xx status code
func (o *PodStartLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod start libpod o k response has a 4xx status code
func (o *PodStartLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this pod start libpod o k response has a 5xx status code
func (o *PodStartLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this pod start libpod o k response a status code equal to that given
func (o *PodStartLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *PodStartLibpodOK) Error() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/start][%d] podStartLibpodOK  %+v", 200, o.Payload)
}

func (o *PodStartLibpodOK) String() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/start][%d] podStartLibpodOK  %+v", 200, o.Payload)
}

func (o *PodStartLibpodOK) GetPayload() *models.PodStartReport {
	return o.Payload
}

func (o *PodStartLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PodStartReport)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPodStartLibpodNotModified creates a PodStartLibpodNotModified with default headers values
func NewPodStartLibpodNotModified() *PodStartLibpodNotModified {
	return &PodStartLibpodNotModified{}
}

/*
PodStartLibpodNotModified describes a response with status code 304, with default header values.

Pod already started
*/
type PodStartLibpodNotModified struct {
	Payload *PodStartLibpodNotModifiedBody
}

// IsSuccess returns true when this pod start libpod not modified response has a 2xx status code
func (o *PodStartLibpodNotModified) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this pod start libpod not modified response has a 3xx status code
func (o *PodStartLibpodNotModified) IsRedirect() bool {
	return true
}

// IsClientError returns true when this pod start libpod not modified response has a 4xx status code
func (o *PodStartLibpodNotModified) IsClientError() bool {
	return false
}

// IsServerError returns true when this pod start libpod not modified response has a 5xx status code
func (o *PodStartLibpodNotModified) IsServerError() bool {
	return false
}

// IsCode returns true when this pod start libpod not modified response a status code equal to that given
func (o *PodStartLibpodNotModified) IsCode(code int) bool {
	return code == 304
}

func (o *PodStartLibpodNotModified) Error() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/start][%d] podStartLibpodNotModified  %+v", 304, o.Payload)
}

func (o *PodStartLibpodNotModified) String() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/start][%d] podStartLibpodNotModified  %+v", 304, o.Payload)
}

func (o *PodStartLibpodNotModified) GetPayload() *PodStartLibpodNotModifiedBody {
	return o.Payload
}

func (o *PodStartLibpodNotModified) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(PodStartLibpodNotModifiedBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPodStartLibpodNotFound creates a PodStartLibpodNotFound with default headers values
func NewPodStartLibpodNotFound() *PodStartLibpodNotFound {
	return &PodStartLibpodNotFound{}
}

/*
PodStartLibpodNotFound describes a response with status code 404, with default header values.

No such pod
*/
type PodStartLibpodNotFound struct {
	Payload *PodStartLibpodNotFoundBody
}

// IsSuccess returns true when this pod start libpod not found response has a 2xx status code
func (o *PodStartLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this pod start libpod not found response has a 3xx status code
func (o *PodStartLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod start libpod not found response has a 4xx status code
func (o *PodStartLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this pod start libpod not found response has a 5xx status code
func (o *PodStartLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this pod start libpod not found response a status code equal to that given
func (o *PodStartLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *PodStartLibpodNotFound) Error() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/start][%d] podStartLibpodNotFound  %+v", 404, o.Payload)
}

func (o *PodStartLibpodNotFound) String() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/start][%d] podStartLibpodNotFound  %+v", 404, o.Payload)
}

func (o *PodStartLibpodNotFound) GetPayload() *PodStartLibpodNotFoundBody {
	return o.Payload
}

func (o *PodStartLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(PodStartLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPodStartLibpodConflict creates a PodStartLibpodConflict with default headers values
func NewPodStartLibpodConflict() *PodStartLibpodConflict {
	return &PodStartLibpodConflict{}
}

/*
PodStartLibpodConflict describes a response with status code 409, with default header values.

Start pod
*/
type PodStartLibpodConflict struct {
	Payload *models.PodStartReport
}

// IsSuccess returns true when this pod start libpod conflict response has a 2xx status code
func (o *PodStartLibpodConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this pod start libpod conflict response has a 3xx status code
func (o *PodStartLibpodConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod start libpod conflict response has a 4xx status code
func (o *PodStartLibpodConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this pod start libpod conflict response has a 5xx status code
func (o *PodStartLibpodConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this pod start libpod conflict response a status code equal to that given
func (o *PodStartLibpodConflict) IsCode(code int) bool {
	return code == 409
}

func (o *PodStartLibpodConflict) Error() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/start][%d] podStartLibpodConflict  %+v", 409, o.Payload)
}

func (o *PodStartLibpodConflict) String() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/start][%d] podStartLibpodConflict  %+v", 409, o.Payload)
}

func (o *PodStartLibpodConflict) GetPayload() *models.PodStartReport {
	return o.Payload
}

func (o *PodStartLibpodConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PodStartReport)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPodStartLibpodInternalServerError creates a PodStartLibpodInternalServerError with default headers values
func NewPodStartLibpodInternalServerError() *PodStartLibpodInternalServerError {
	return &PodStartLibpodInternalServerError{}
}

/*
PodStartLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type PodStartLibpodInternalServerError struct {
	Payload *PodStartLibpodInternalServerErrorBody
}

// IsSuccess returns true when this pod start libpod internal server error response has a 2xx status code
func (o *PodStartLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this pod start libpod internal server error response has a 3xx status code
func (o *PodStartLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod start libpod internal server error response has a 4xx status code
func (o *PodStartLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this pod start libpod internal server error response has a 5xx status code
func (o *PodStartLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this pod start libpod internal server error response a status code equal to that given
func (o *PodStartLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *PodStartLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/start][%d] podStartLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *PodStartLibpodInternalServerError) String() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/start][%d] podStartLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *PodStartLibpodInternalServerError) GetPayload() *PodStartLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *PodStartLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(PodStartLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
PodStartLibpodInternalServerErrorBody pod start libpod internal server error body
swagger:model PodStartLibpodInternalServerErrorBody
*/
type PodStartLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this pod start libpod internal server error body
func (o *PodStartLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this pod start libpod internal server error body based on context it is used
func (o *PodStartLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PodStartLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PodStartLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res PodStartLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PodStartLibpodNotFoundBody pod start libpod not found body
swagger:model PodStartLibpodNotFoundBody
*/
type PodStartLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this pod start libpod not found body
func (o *PodStartLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this pod start libpod not found body based on context it is used
func (o *PodStartLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PodStartLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PodStartLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res PodStartLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PodStartLibpodNotModifiedBody pod start libpod not modified body
swagger:model PodStartLibpodNotModifiedBody
*/
type PodStartLibpodNotModifiedBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this pod start libpod not modified body
func (o *PodStartLibpodNotModifiedBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this pod start libpod not modified body based on context it is used
func (o *PodStartLibpodNotModifiedBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PodStartLibpodNotModifiedBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PodStartLibpodNotModifiedBody) UnmarshalBinary(b []byte) error {
	var res PodStartLibpodNotModifiedBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
