// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewContainerChangesLibpodParams creates a new ContainerChangesLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewContainerChangesLibpodParams() *ContainerChangesLibpodParams {
	return &ContainerChangesLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewContainerChangesLibpodParamsWithTimeout creates a new ContainerChangesLibpodParams object
// with the ability to set a timeout on a request.
func NewContainerChangesLibpodParamsWithTimeout(timeout time.Duration) *ContainerChangesLibpodParams {
	return &ContainerChangesLibpodParams{
		timeout: timeout,
	}
}

// NewContainerChangesLibpodParamsWithContext creates a new ContainerChangesLibpodParams object
// with the ability to set a context for a request.
func NewContainerChangesLibpodParamsWithContext(ctx context.Context) *ContainerChangesLibpodParams {
	return &ContainerChangesLibpodParams{
		Context: ctx,
	}
}

// NewContainerChangesLibpodParamsWithHTTPClient creates a new ContainerChangesLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewContainerChangesLibpodParamsWithHTTPClient(client *http.Client) *ContainerChangesLibpodParams {
	return &ContainerChangesLibpodParams{
		HTTPClient: client,
	}
}

/*
ContainerChangesLibpodParams contains all the parameters to send to the API endpoint

	for the container changes libpod operation.

	Typically these are written to a http.Request.
*/
type ContainerChangesLibpodParams struct {

	/* DiffType.

	   select what you want to match, default is all
	*/
	DiffType *string

	/* Name.

	   the name or id of the container
	*/
	Name string

	/* Parent.

	   specify a second layer which is used to compare against it instead of the parent layer
	*/
	Parent *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the container changes libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerChangesLibpodParams) WithDefaults() *ContainerChangesLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the container changes libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerChangesLibpodParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the container changes libpod params
func (o *ContainerChangesLibpodParams) WithTimeout(timeout time.Duration) *ContainerChangesLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the container changes libpod params
func (o *ContainerChangesLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the container changes libpod params
func (o *ContainerChangesLibpodParams) WithContext(ctx context.Context) *ContainerChangesLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the container changes libpod params
func (o *ContainerChangesLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the container changes libpod params
func (o *ContainerChangesLibpodParams) WithHTTPClient(client *http.Client) *ContainerChangesLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the container changes libpod params
func (o *ContainerChangesLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDiffType adds the diffType to the container changes libpod params
func (o *ContainerChangesLibpodParams) WithDiffType(diffType *string) *ContainerChangesLibpodParams {
	o.SetDiffType(diffType)
	return o
}

// SetDiffType adds the diffType to the container changes libpod params
func (o *ContainerChangesLibpodParams) SetDiffType(diffType *string) {
	o.DiffType = diffType
}

// WithName adds the name to the container changes libpod params
func (o *ContainerChangesLibpodParams) WithName(name string) *ContainerChangesLibpodParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the container changes libpod params
func (o *ContainerChangesLibpodParams) SetName(name string) {
	o.Name = name
}

// WithParent adds the parent to the container changes libpod params
func (o *ContainerChangesLibpodParams) WithParent(parent *string) *ContainerChangesLibpodParams {
	o.SetParent(parent)
	return o
}

// SetParent adds the parent to the container changes libpod params
func (o *ContainerChangesLibpodParams) SetParent(parent *string) {
	o.Parent = parent
}

// WriteToRequest writes these params to a swagger request
func (o *ContainerChangesLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.DiffType != nil {

		// query param diffType
		var qrDiffType string

		if o.DiffType != nil {
			qrDiffType = *o.DiffType
		}
		qDiffType := qrDiffType
		if qDiffType != "" {

			if err := r.SetQueryParam("diffType", qDiffType); err != nil {
				return err
			}
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.Parent != nil {

		// query param parent
		var qrParent string

		if o.Parent != nil {
			qrParent = *o.Parent
		}
		qParent := qrParent
		if qParent != "" {

			if err := r.SetQueryParam("parent", qParent); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
