// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ContainerCreateLibpodReader is a Reader for the ContainerCreateLibpod structure.
type ContainerCreateLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ContainerCreateLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewContainerCreateLibpodCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewContainerCreateLibpodBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewContainerCreateLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewContainerCreateLibpodConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewContainerCreateLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewContainerCreateLibpodCreated creates a ContainerCreateLibpodCreated with default headers values
func NewContainerCreateLibpodCreated() *ContainerCreateLibpodCreated {
	return &ContainerCreateLibpodCreated{}
}

/*
ContainerCreateLibpodCreated describes a response with status code 201, with default header values.

Create container
*/
type ContainerCreateLibpodCreated struct {
	Payload *ContainerCreateLibpodCreatedBody
}

// IsSuccess returns true when this container create libpod created response has a 2xx status code
func (o *ContainerCreateLibpodCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this container create libpod created response has a 3xx status code
func (o *ContainerCreateLibpodCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container create libpod created response has a 4xx status code
func (o *ContainerCreateLibpodCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this container create libpod created response has a 5xx status code
func (o *ContainerCreateLibpodCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this container create libpod created response a status code equal to that given
func (o *ContainerCreateLibpodCreated) IsCode(code int) bool {
	return code == 201
}

func (o *ContainerCreateLibpodCreated) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/create][%d] containerCreateLibpodCreated  %+v", 201, o.Payload)
}

func (o *ContainerCreateLibpodCreated) String() string {
	return fmt.Sprintf("[POST /libpod/containers/create][%d] containerCreateLibpodCreated  %+v", 201, o.Payload)
}

func (o *ContainerCreateLibpodCreated) GetPayload() *ContainerCreateLibpodCreatedBody {
	return o.Payload
}

func (o *ContainerCreateLibpodCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerCreateLibpodCreatedBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerCreateLibpodBadRequest creates a ContainerCreateLibpodBadRequest with default headers values
func NewContainerCreateLibpodBadRequest() *ContainerCreateLibpodBadRequest {
	return &ContainerCreateLibpodBadRequest{}
}

/*
ContainerCreateLibpodBadRequest describes a response with status code 400, with default header values.

Bad parameter in request
*/
type ContainerCreateLibpodBadRequest struct {
	Payload *ContainerCreateLibpodBadRequestBody
}

// IsSuccess returns true when this container create libpod bad request response has a 2xx status code
func (o *ContainerCreateLibpodBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container create libpod bad request response has a 3xx status code
func (o *ContainerCreateLibpodBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container create libpod bad request response has a 4xx status code
func (o *ContainerCreateLibpodBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this container create libpod bad request response has a 5xx status code
func (o *ContainerCreateLibpodBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this container create libpod bad request response a status code equal to that given
func (o *ContainerCreateLibpodBadRequest) IsCode(code int) bool {
	return code == 400
}

func (o *ContainerCreateLibpodBadRequest) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/create][%d] containerCreateLibpodBadRequest  %+v", 400, o.Payload)
}

func (o *ContainerCreateLibpodBadRequest) String() string {
	return fmt.Sprintf("[POST /libpod/containers/create][%d] containerCreateLibpodBadRequest  %+v", 400, o.Payload)
}

func (o *ContainerCreateLibpodBadRequest) GetPayload() *ContainerCreateLibpodBadRequestBody {
	return o.Payload
}

func (o *ContainerCreateLibpodBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerCreateLibpodBadRequestBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerCreateLibpodNotFound creates a ContainerCreateLibpodNotFound with default headers values
func NewContainerCreateLibpodNotFound() *ContainerCreateLibpodNotFound {
	return &ContainerCreateLibpodNotFound{}
}

/*
ContainerCreateLibpodNotFound describes a response with status code 404, with default header values.

No such container
*/
type ContainerCreateLibpodNotFound struct {
	Payload *ContainerCreateLibpodNotFoundBody
}

// IsSuccess returns true when this container create libpod not found response has a 2xx status code
func (o *ContainerCreateLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container create libpod not found response has a 3xx status code
func (o *ContainerCreateLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container create libpod not found response has a 4xx status code
func (o *ContainerCreateLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this container create libpod not found response has a 5xx status code
func (o *ContainerCreateLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this container create libpod not found response a status code equal to that given
func (o *ContainerCreateLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ContainerCreateLibpodNotFound) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/create][%d] containerCreateLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerCreateLibpodNotFound) String() string {
	return fmt.Sprintf("[POST /libpod/containers/create][%d] containerCreateLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerCreateLibpodNotFound) GetPayload() *ContainerCreateLibpodNotFoundBody {
	return o.Payload
}

func (o *ContainerCreateLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerCreateLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerCreateLibpodConflict creates a ContainerCreateLibpodConflict with default headers values
func NewContainerCreateLibpodConflict() *ContainerCreateLibpodConflict {
	return &ContainerCreateLibpodConflict{}
}

/*
ContainerCreateLibpodConflict describes a response with status code 409, with default header values.

Conflict error in operation
*/
type ContainerCreateLibpodConflict struct {
	Payload *ContainerCreateLibpodConflictBody
}

// IsSuccess returns true when this container create libpod conflict response has a 2xx status code
func (o *ContainerCreateLibpodConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container create libpod conflict response has a 3xx status code
func (o *ContainerCreateLibpodConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container create libpod conflict response has a 4xx status code
func (o *ContainerCreateLibpodConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this container create libpod conflict response has a 5xx status code
func (o *ContainerCreateLibpodConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this container create libpod conflict response a status code equal to that given
func (o *ContainerCreateLibpodConflict) IsCode(code int) bool {
	return code == 409
}

func (o *ContainerCreateLibpodConflict) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/create][%d] containerCreateLibpodConflict  %+v", 409, o.Payload)
}

func (o *ContainerCreateLibpodConflict) String() string {
	return fmt.Sprintf("[POST /libpod/containers/create][%d] containerCreateLibpodConflict  %+v", 409, o.Payload)
}

func (o *ContainerCreateLibpodConflict) GetPayload() *ContainerCreateLibpodConflictBody {
	return o.Payload
}

func (o *ContainerCreateLibpodConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerCreateLibpodConflictBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerCreateLibpodInternalServerError creates a ContainerCreateLibpodInternalServerError with default headers values
func NewContainerCreateLibpodInternalServerError() *ContainerCreateLibpodInternalServerError {
	return &ContainerCreateLibpodInternalServerError{}
}

/*
ContainerCreateLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ContainerCreateLibpodInternalServerError struct {
	Payload *ContainerCreateLibpodInternalServerErrorBody
}

// IsSuccess returns true when this container create libpod internal server error response has a 2xx status code
func (o *ContainerCreateLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container create libpod internal server error response has a 3xx status code
func (o *ContainerCreateLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container create libpod internal server error response has a 4xx status code
func (o *ContainerCreateLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this container create libpod internal server error response has a 5xx status code
func (o *ContainerCreateLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this container create libpod internal server error response a status code equal to that given
func (o *ContainerCreateLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ContainerCreateLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/create][%d] containerCreateLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerCreateLibpodInternalServerError) String() string {
	return fmt.Sprintf("[POST /libpod/containers/create][%d] containerCreateLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerCreateLibpodInternalServerError) GetPayload() *ContainerCreateLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ContainerCreateLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerCreateLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ContainerCreateLibpodBadRequestBody container create libpod bad request body
swagger:model ContainerCreateLibpodBadRequestBody
*/
type ContainerCreateLibpodBadRequestBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container create libpod bad request body
func (o *ContainerCreateLibpodBadRequestBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container create libpod bad request body based on context it is used
func (o *ContainerCreateLibpodBadRequestBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerCreateLibpodBadRequestBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerCreateLibpodBadRequestBody) UnmarshalBinary(b []byte) error {
	var res ContainerCreateLibpodBadRequestBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerCreateLibpodConflictBody container create libpod conflict body
swagger:model ContainerCreateLibpodConflictBody
*/
type ContainerCreateLibpodConflictBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container create libpod conflict body
func (o *ContainerCreateLibpodConflictBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container create libpod conflict body based on context it is used
func (o *ContainerCreateLibpodConflictBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerCreateLibpodConflictBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerCreateLibpodConflictBody) UnmarshalBinary(b []byte) error {
	var res ContainerCreateLibpodConflictBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerCreateLibpodCreatedBody container create libpod created body
swagger:model ContainerCreateLibpodCreatedBody
*/
type ContainerCreateLibpodCreatedBody struct {

	// ID of the container created
	ID string `json:"Id,omitempty"`

	// Warnings during container creation
	Warnings []string `json:"Warnings"`
}

// Validate validates this container create libpod created body
func (o *ContainerCreateLibpodCreatedBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container create libpod created body based on context it is used
func (o *ContainerCreateLibpodCreatedBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerCreateLibpodCreatedBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerCreateLibpodCreatedBody) UnmarshalBinary(b []byte) error {
	var res ContainerCreateLibpodCreatedBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerCreateLibpodInternalServerErrorBody container create libpod internal server error body
swagger:model ContainerCreateLibpodInternalServerErrorBody
*/
type ContainerCreateLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container create libpod internal server error body
func (o *ContainerCreateLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container create libpod internal server error body based on context it is used
func (o *ContainerCreateLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerCreateLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerCreateLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ContainerCreateLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerCreateLibpodNotFoundBody container create libpod not found body
swagger:model ContainerCreateLibpodNotFoundBody
*/
type ContainerCreateLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container create libpod not found body
func (o *ContainerCreateLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container create libpod not found body based on context it is used
func (o *ContainerCreateLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerCreateLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerCreateLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ContainerCreateLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
