// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewContainerKillLibpodParams creates a new ContainerKillLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewContainerKillLibpodParams() *ContainerKillLibpodParams {
	return &ContainerKillLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewContainerKillLibpodParamsWithTimeout creates a new ContainerKillLibpodParams object
// with the ability to set a timeout on a request.
func NewContainerKillLibpodParamsWithTimeout(timeout time.Duration) *ContainerKillLibpodParams {
	return &ContainerKillLibpodParams{
		timeout: timeout,
	}
}

// NewContainerKillLibpodParamsWithContext creates a new ContainerKillLibpodParams object
// with the ability to set a context for a request.
func NewContainerKillLibpodParamsWithContext(ctx context.Context) *ContainerKillLibpodParams {
	return &ContainerKillLibpodParams{
		Context: ctx,
	}
}

// NewContainerKillLibpodParamsWithHTTPClient creates a new ContainerKillLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewContainerKillLibpodParamsWithHTTPClient(client *http.Client) *ContainerKillLibpodParams {
	return &ContainerKillLibpodParams{
		HTTPClient: client,
	}
}

/*
ContainerKillLibpodParams contains all the parameters to send to the API endpoint

	for the container kill libpod operation.

	Typically these are written to a http.Request.
*/
type ContainerKillLibpodParams struct {

	/* Name.

	   the name or ID of the container
	*/
	Name string

	/* Signal.

	   signal to be sent to container, either by integer or SIG_ name

	   Default: "TERM"
	*/
	Signal *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the container kill libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerKillLibpodParams) WithDefaults() *ContainerKillLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the container kill libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerKillLibpodParams) SetDefaults() {
	var (
		signalDefault = string("TERM")
	)

	val := ContainerKillLibpodParams{
		Signal: &signalDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the container kill libpod params
func (o *ContainerKillLibpodParams) WithTimeout(timeout time.Duration) *ContainerKillLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the container kill libpod params
func (o *ContainerKillLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the container kill libpod params
func (o *ContainerKillLibpodParams) WithContext(ctx context.Context) *ContainerKillLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the container kill libpod params
func (o *ContainerKillLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the container kill libpod params
func (o *ContainerKillLibpodParams) WithHTTPClient(client *http.Client) *ContainerKillLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the container kill libpod params
func (o *ContainerKillLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithName adds the name to the container kill libpod params
func (o *ContainerKillLibpodParams) WithName(name string) *ContainerKillLibpodParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the container kill libpod params
func (o *ContainerKillLibpodParams) SetName(name string) {
	o.Name = name
}

// WithSignal adds the signal to the container kill libpod params
func (o *ContainerKillLibpodParams) WithSignal(signal *string) *ContainerKillLibpodParams {
	o.SetSignal(signal)
	return o
}

// SetSignal adds the signal to the container kill libpod params
func (o *ContainerKillLibpodParams) SetSignal(signal *string) {
	o.Signal = signal
}

// WriteToRequest writes these params to a swagger request
func (o *ContainerKillLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.Signal != nil {

		// query param signal
		var qrSignal string

		if o.Signal != nil {
			qrSignal = *o.Signal
		}
		qSignal := qrSignal
		if qSignal != "" {

			if err := r.SetQueryParam("signal", qSignal); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
