// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewContainerRestartLibpodParams creates a new ContainerRestartLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewContainerRestartLibpodParams() *ContainerRestartLibpodParams {
	return &ContainerRestartLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewContainerRestartLibpodParamsWithTimeout creates a new ContainerRestartLibpodParams object
// with the ability to set a timeout on a request.
func NewContainerRestartLibpodParamsWithTimeout(timeout time.Duration) *ContainerRestartLibpodParams {
	return &ContainerRestartLibpodParams{
		timeout: timeout,
	}
}

// NewContainerRestartLibpodParamsWithContext creates a new ContainerRestartLibpodParams object
// with the ability to set a context for a request.
func NewContainerRestartLibpodParamsWithContext(ctx context.Context) *ContainerRestartLibpodParams {
	return &ContainerRestartLibpodParams{
		Context: ctx,
	}
}

// NewContainerRestartLibpodParamsWithHTTPClient creates a new ContainerRestartLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewContainerRestartLibpodParamsWithHTTPClient(client *http.Client) *ContainerRestartLibpodParams {
	return &ContainerRestartLibpodParams{
		HTTPClient: client,
	}
}

/*
ContainerRestartLibpodParams contains all the parameters to send to the API endpoint

	for the container restart libpod operation.

	Typically these are written to a http.Request.
*/
type ContainerRestartLibpodParams struct {

	/* Name.

	   the name or ID of the container
	*/
	Name string

	/* T.

	   number of seconds to wait before killing container

	   Default: 10
	*/
	T *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the container restart libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerRestartLibpodParams) WithDefaults() *ContainerRestartLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the container restart libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerRestartLibpodParams) SetDefaults() {
	var (
		tDefault = int64(10)
	)

	val := ContainerRestartLibpodParams{
		T: &tDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the container restart libpod params
func (o *ContainerRestartLibpodParams) WithTimeout(timeout time.Duration) *ContainerRestartLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the container restart libpod params
func (o *ContainerRestartLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the container restart libpod params
func (o *ContainerRestartLibpodParams) WithContext(ctx context.Context) *ContainerRestartLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the container restart libpod params
func (o *ContainerRestartLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the container restart libpod params
func (o *ContainerRestartLibpodParams) WithHTTPClient(client *http.Client) *ContainerRestartLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the container restart libpod params
func (o *ContainerRestartLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithName adds the name to the container restart libpod params
func (o *ContainerRestartLibpodParams) WithName(name string) *ContainerRestartLibpodParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the container restart libpod params
func (o *ContainerRestartLibpodParams) SetName(name string) {
	o.Name = name
}

// WithT adds the t to the container restart libpod params
func (o *ContainerRestartLibpodParams) WithT(t *int64) *ContainerRestartLibpodParams {
	o.SetT(t)
	return o
}

// SetT adds the t to the container restart libpod params
func (o *ContainerRestartLibpodParams) SetT(t *int64) {
	o.T = t
}

// WriteToRequest writes these params to a swagger request
func (o *ContainerRestartLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.T != nil {

		// query param t
		var qrT int64

		if o.T != nil {
			qrT = *o.T
		}
		qT := swag.FormatInt64(qrT)
		if qT != "" {

			if err := r.SetQueryParam("t", qT); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
