// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ImageCommitLibpodReader is a Reader for the ImageCommitLibpod structure.
type ImageCommitLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ImageCommitLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewImageCommitLibpodCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewImageCommitLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewImageCommitLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewImageCommitLibpodCreated creates a ImageCommitLibpodCreated with default headers values
func NewImageCommitLibpodCreated() *ImageCommitLibpodCreated {
	return &ImageCommitLibpodCreated{}
}

/*
ImageCommitLibpodCreated describes a response with status code 201, with default header values.

no error
*/
type ImageCommitLibpodCreated struct {
}

// IsSuccess returns true when this image commit libpod created response has a 2xx status code
func (o *ImageCommitLibpodCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this image commit libpod created response has a 3xx status code
func (o *ImageCommitLibpodCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image commit libpod created response has a 4xx status code
func (o *ImageCommitLibpodCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this image commit libpod created response has a 5xx status code
func (o *ImageCommitLibpodCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this image commit libpod created response a status code equal to that given
func (o *ImageCommitLibpodCreated) IsCode(code int) bool {
	return code == 201
}

func (o *ImageCommitLibpodCreated) Error() string {
	return fmt.Sprintf("[POST /libpod/commit][%d] imageCommitLibpodCreated ", 201)
}

func (o *ImageCommitLibpodCreated) String() string {
	return fmt.Sprintf("[POST /libpod/commit][%d] imageCommitLibpodCreated ", 201)
}

func (o *ImageCommitLibpodCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewImageCommitLibpodNotFound creates a ImageCommitLibpodNotFound with default headers values
func NewImageCommitLibpodNotFound() *ImageCommitLibpodNotFound {
	return &ImageCommitLibpodNotFound{}
}

/*
ImageCommitLibpodNotFound describes a response with status code 404, with default header values.

No such image
*/
type ImageCommitLibpodNotFound struct {
	Payload *ImageCommitLibpodNotFoundBody
}

// IsSuccess returns true when this image commit libpod not found response has a 2xx status code
func (o *ImageCommitLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image commit libpod not found response has a 3xx status code
func (o *ImageCommitLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image commit libpod not found response has a 4xx status code
func (o *ImageCommitLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this image commit libpod not found response has a 5xx status code
func (o *ImageCommitLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this image commit libpod not found response a status code equal to that given
func (o *ImageCommitLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ImageCommitLibpodNotFound) Error() string {
	return fmt.Sprintf("[POST /libpod/commit][%d] imageCommitLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ImageCommitLibpodNotFound) String() string {
	return fmt.Sprintf("[POST /libpod/commit][%d] imageCommitLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ImageCommitLibpodNotFound) GetPayload() *ImageCommitLibpodNotFoundBody {
	return o.Payload
}

func (o *ImageCommitLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageCommitLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImageCommitLibpodInternalServerError creates a ImageCommitLibpodInternalServerError with default headers values
func NewImageCommitLibpodInternalServerError() *ImageCommitLibpodInternalServerError {
	return &ImageCommitLibpodInternalServerError{}
}

/*
ImageCommitLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ImageCommitLibpodInternalServerError struct {
	Payload *ImageCommitLibpodInternalServerErrorBody
}

// IsSuccess returns true when this image commit libpod internal server error response has a 2xx status code
func (o *ImageCommitLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image commit libpod internal server error response has a 3xx status code
func (o *ImageCommitLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image commit libpod internal server error response has a 4xx status code
func (o *ImageCommitLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this image commit libpod internal server error response has a 5xx status code
func (o *ImageCommitLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this image commit libpod internal server error response a status code equal to that given
func (o *ImageCommitLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ImageCommitLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[POST /libpod/commit][%d] imageCommitLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageCommitLibpodInternalServerError) String() string {
	return fmt.Sprintf("[POST /libpod/commit][%d] imageCommitLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageCommitLibpodInternalServerError) GetPayload() *ImageCommitLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ImageCommitLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageCommitLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ImageCommitLibpodInternalServerErrorBody image commit libpod internal server error body
swagger:model ImageCommitLibpodInternalServerErrorBody
*/
type ImageCommitLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image commit libpod internal server error body
func (o *ImageCommitLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image commit libpod internal server error body based on context it is used
func (o *ImageCommitLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageCommitLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageCommitLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ImageCommitLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ImageCommitLibpodNotFoundBody image commit libpod not found body
swagger:model ImageCommitLibpodNotFoundBody
*/
type ImageCommitLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image commit libpod not found body
func (o *ImageCommitLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image commit libpod not found body based on context it is used
func (o *ImageCommitLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageCommitLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageCommitLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ImageCommitLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
