// Code generated by go-swagger; DO NOT EDIT.

package exec

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new exec API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for exec API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	ContainerExecLibpod(params *ContainerExecLibpodParams, opts ...ClientOption) (*ContainerExecLibpodCreated, error)

	ExecInspectLibpod(params *ExecInspectLibpodParams, opts ...ClientOption) (*ExecInspectLibpodOK, error)

	ExecResizeLibpod(params *ExecResizeLibpodParams, opts ...ClientOption) (*ExecResizeLibpodCreated, error)

	ExecStartLibpod(params *ExecStartLibpodParams, opts ...ClientOption) (*ExecStartLibpodOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
ContainerExecLibpod creates an exec instance

Create an exec session to run a command inside a running container. Exec sessions will be automatically removed 5 minutes after they exit.
*/
func (a *Client) ContainerExecLibpod(params *ContainerExecLibpodParams, opts ...ClientOption) (*ContainerExecLibpodCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerExecLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ContainerExecLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/containers/{name}/exec",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ContainerExecLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ContainerExecLibpodCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ContainerExecLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ExecInspectLibpod inspects an exec instance

Return low-level information about an exec instance.
*/
func (a *Client) ExecInspectLibpod(params *ExecInspectLibpodParams, opts ...ClientOption) (*ExecInspectLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewExecInspectLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ExecInspectLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/exec/{id}/json",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ExecInspectLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ExecInspectLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ExecInspectLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ExecResizeLibpod resizes an exec instance

Resize the TTY session used by an exec instance. This endpoint only works if tty was specified as part of creating and starting the exec instance.
*/
func (a *Client) ExecResizeLibpod(params *ExecResizeLibpodParams, opts ...ClientOption) (*ExecResizeLibpodCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewExecResizeLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ExecResizeLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/exec/{id}/resize",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ExecResizeLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ExecResizeLibpodCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ExecResizeLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ExecStartLibpod starts an exec instance

Starts a previously set up exec instance. If detach is true, this endpoint returns immediately after starting the command. Otherwise, it sets up an interactive session with the command.
*/
func (a *Client) ExecStartLibpod(params *ExecStartLibpodParams, opts ...ClientOption) (*ExecStartLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewExecStartLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ExecStartLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/exec/{id}/start",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ExecStartLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ExecStartLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for ExecStartLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
