// Code generated by go-swagger; DO NOT EDIT.

package images

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ImageBuildLibpodReader is a Reader for the ImageBuildLibpod structure.
type ImageBuildLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ImageBuildLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewImageBuildLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewImageBuildLibpodBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewImageBuildLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewImageBuildLibpodOK creates a ImageBuildLibpodOK with default headers values
func NewImageBuildLibpodOK() *ImageBuildLibpodOK {
	return &ImageBuildLibpodOK{}
}

/*
ImageBuildLibpodOK describes a response with status code 200, with default header values.

OK (As of version 1.xx)
*/
type ImageBuildLibpodOK struct {
	Payload *ImageBuildLibpodOKBody
}

// IsSuccess returns true when this image build libpod o k response has a 2xx status code
func (o *ImageBuildLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this image build libpod o k response has a 3xx status code
func (o *ImageBuildLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image build libpod o k response has a 4xx status code
func (o *ImageBuildLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this image build libpod o k response has a 5xx status code
func (o *ImageBuildLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this image build libpod o k response a status code equal to that given
func (o *ImageBuildLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *ImageBuildLibpodOK) Error() string {
	return fmt.Sprintf("[POST /libpod/build][%d] imageBuildLibpodOK  %+v", 200, o.Payload)
}

func (o *ImageBuildLibpodOK) String() string {
	return fmt.Sprintf("[POST /libpod/build][%d] imageBuildLibpodOK  %+v", 200, o.Payload)
}

func (o *ImageBuildLibpodOK) GetPayload() *ImageBuildLibpodOKBody {
	return o.Payload
}

func (o *ImageBuildLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageBuildLibpodOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImageBuildLibpodBadRequest creates a ImageBuildLibpodBadRequest with default headers values
func NewImageBuildLibpodBadRequest() *ImageBuildLibpodBadRequest {
	return &ImageBuildLibpodBadRequest{}
}

/*
ImageBuildLibpodBadRequest describes a response with status code 400, with default header values.

Bad parameter in request
*/
type ImageBuildLibpodBadRequest struct {
	Payload *ImageBuildLibpodBadRequestBody
}

// IsSuccess returns true when this image build libpod bad request response has a 2xx status code
func (o *ImageBuildLibpodBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image build libpod bad request response has a 3xx status code
func (o *ImageBuildLibpodBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image build libpod bad request response has a 4xx status code
func (o *ImageBuildLibpodBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this image build libpod bad request response has a 5xx status code
func (o *ImageBuildLibpodBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this image build libpod bad request response a status code equal to that given
func (o *ImageBuildLibpodBadRequest) IsCode(code int) bool {
	return code == 400
}

func (o *ImageBuildLibpodBadRequest) Error() string {
	return fmt.Sprintf("[POST /libpod/build][%d] imageBuildLibpodBadRequest  %+v", 400, o.Payload)
}

func (o *ImageBuildLibpodBadRequest) String() string {
	return fmt.Sprintf("[POST /libpod/build][%d] imageBuildLibpodBadRequest  %+v", 400, o.Payload)
}

func (o *ImageBuildLibpodBadRequest) GetPayload() *ImageBuildLibpodBadRequestBody {
	return o.Payload
}

func (o *ImageBuildLibpodBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageBuildLibpodBadRequestBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImageBuildLibpodInternalServerError creates a ImageBuildLibpodInternalServerError with default headers values
func NewImageBuildLibpodInternalServerError() *ImageBuildLibpodInternalServerError {
	return &ImageBuildLibpodInternalServerError{}
}

/*
ImageBuildLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ImageBuildLibpodInternalServerError struct {
	Payload *ImageBuildLibpodInternalServerErrorBody
}

// IsSuccess returns true when this image build libpod internal server error response has a 2xx status code
func (o *ImageBuildLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image build libpod internal server error response has a 3xx status code
func (o *ImageBuildLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image build libpod internal server error response has a 4xx status code
func (o *ImageBuildLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this image build libpod internal server error response has a 5xx status code
func (o *ImageBuildLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this image build libpod internal server error response a status code equal to that given
func (o *ImageBuildLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ImageBuildLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[POST /libpod/build][%d] imageBuildLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageBuildLibpodInternalServerError) String() string {
	return fmt.Sprintf("[POST /libpod/build][%d] imageBuildLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageBuildLibpodInternalServerError) GetPayload() *ImageBuildLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ImageBuildLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageBuildLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ImageBuildLibpodBadRequestBody image build libpod bad request body
swagger:model ImageBuildLibpodBadRequestBody
*/
type ImageBuildLibpodBadRequestBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image build libpod bad request body
func (o *ImageBuildLibpodBadRequestBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image build libpod bad request body based on context it is used
func (o *ImageBuildLibpodBadRequestBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageBuildLibpodBadRequestBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageBuildLibpodBadRequestBody) UnmarshalBinary(b []byte) error {
	var res ImageBuildLibpodBadRequestBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ImageBuildLibpodInternalServerErrorBody image build libpod internal server error body
swagger:model ImageBuildLibpodInternalServerErrorBody
*/
type ImageBuildLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image build libpod internal server error body
func (o *ImageBuildLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image build libpod internal server error body based on context it is used
func (o *ImageBuildLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageBuildLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageBuildLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ImageBuildLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ImageBuildLibpodOKBody image build libpod o k body
swagger:model ImageBuildLibpodOKBody
*/
type ImageBuildLibpodOKBody struct {

	// output from build process
	// Example: (build details...)\n
	// Required: true
	Stream *string `json:"stream"`
}

// Validate validates this image build libpod o k body
func (o *ImageBuildLibpodOKBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateStream(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ImageBuildLibpodOKBody) validateStream(formats strfmt.Registry) error {

	if err := validate.Required("imageBuildLibpodOK"+"."+"stream", "body", o.Stream); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this image build libpod o k body based on context it is used
func (o *ImageBuildLibpodOKBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageBuildLibpodOKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageBuildLibpodOKBody) UnmarshalBinary(b []byte) error {
	var res ImageBuildLibpodOKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
