// Code generated by go-swagger; DO NOT EDIT.

package images

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// ImagePruneLibpodReader is a Reader for the ImagePruneLibpod structure.
type ImagePruneLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ImagePruneLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewImagePruneLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 500:
		result := NewImagePruneLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewImagePruneLibpodOK creates a ImagePruneLibpodOK with default headers values
func NewImagePruneLibpodOK() *ImagePruneLibpodOK {
	return &ImagePruneLibpodOK{}
}

/*
ImagePruneLibpodOK describes a response with status code 200, with default header values.

Prune containers
*/
type ImagePruneLibpodOK struct {
	Payload []*models.LibpodContainersPruneReport
}

// IsSuccess returns true when this image prune libpod o k response has a 2xx status code
func (o *ImagePruneLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this image prune libpod o k response has a 3xx status code
func (o *ImagePruneLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image prune libpod o k response has a 4xx status code
func (o *ImagePruneLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this image prune libpod o k response has a 5xx status code
func (o *ImagePruneLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this image prune libpod o k response a status code equal to that given
func (o *ImagePruneLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *ImagePruneLibpodOK) Error() string {
	return fmt.Sprintf("[POST /libpod/images/prune][%d] imagePruneLibpodOK  %+v", 200, o.Payload)
}

func (o *ImagePruneLibpodOK) String() string {
	return fmt.Sprintf("[POST /libpod/images/prune][%d] imagePruneLibpodOK  %+v", 200, o.Payload)
}

func (o *ImagePruneLibpodOK) GetPayload() []*models.LibpodContainersPruneReport {
	return o.Payload
}

func (o *ImagePruneLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImagePruneLibpodInternalServerError creates a ImagePruneLibpodInternalServerError with default headers values
func NewImagePruneLibpodInternalServerError() *ImagePruneLibpodInternalServerError {
	return &ImagePruneLibpodInternalServerError{}
}

/*
ImagePruneLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ImagePruneLibpodInternalServerError struct {
	Payload *ImagePruneLibpodInternalServerErrorBody
}

// IsSuccess returns true when this image prune libpod internal server error response has a 2xx status code
func (o *ImagePruneLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image prune libpod internal server error response has a 3xx status code
func (o *ImagePruneLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image prune libpod internal server error response has a 4xx status code
func (o *ImagePruneLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this image prune libpod internal server error response has a 5xx status code
func (o *ImagePruneLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this image prune libpod internal server error response a status code equal to that given
func (o *ImagePruneLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ImagePruneLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[POST /libpod/images/prune][%d] imagePruneLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ImagePruneLibpodInternalServerError) String() string {
	return fmt.Sprintf("[POST /libpod/images/prune][%d] imagePruneLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ImagePruneLibpodInternalServerError) GetPayload() *ImagePruneLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ImagePruneLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImagePruneLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ImagePruneLibpodInternalServerErrorBody image prune libpod internal server error body
swagger:model ImagePruneLibpodInternalServerErrorBody
*/
type ImagePruneLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image prune libpod internal server error body
func (o *ImagePruneLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image prune libpod internal server error body based on context it is used
func (o *ImagePruneLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImagePruneLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImagePruneLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ImagePruneLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
