// Code generated by go-swagger; DO NOT EDIT.

package images_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ImageHistoryReader is a Reader for the ImageHistory structure.
type ImageHistoryReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ImageHistoryReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewImageHistoryOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewImageHistoryNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewImageHistoryInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewImageHistoryOK creates a ImageHistoryOK with default headers values
func NewImageHistoryOK() *ImageHistoryOK {
	return &ImageHistoryOK{}
}

/*
ImageHistoryOK describes a response with status code 200, with default header values.

History response
*/
type ImageHistoryOK struct {
	Payload *ImageHistoryOKBody
}

// IsSuccess returns true when this image history o k response has a 2xx status code
func (o *ImageHistoryOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this image history o k response has a 3xx status code
func (o *ImageHistoryOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image history o k response has a 4xx status code
func (o *ImageHistoryOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this image history o k response has a 5xx status code
func (o *ImageHistoryOK) IsServerError() bool {
	return false
}

// IsCode returns true when this image history o k response a status code equal to that given
func (o *ImageHistoryOK) IsCode(code int) bool {
	return code == 200
}

func (o *ImageHistoryOK) Error() string {
	return fmt.Sprintf("[GET /images/{name}/history][%d] imageHistoryOK  %+v", 200, o.Payload)
}

func (o *ImageHistoryOK) String() string {
	return fmt.Sprintf("[GET /images/{name}/history][%d] imageHistoryOK  %+v", 200, o.Payload)
}

func (o *ImageHistoryOK) GetPayload() *ImageHistoryOKBody {
	return o.Payload
}

func (o *ImageHistoryOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageHistoryOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImageHistoryNotFound creates a ImageHistoryNotFound with default headers values
func NewImageHistoryNotFound() *ImageHistoryNotFound {
	return &ImageHistoryNotFound{}
}

/*
ImageHistoryNotFound describes a response with status code 404, with default header values.

No such image
*/
type ImageHistoryNotFound struct {
	Payload *ImageHistoryNotFoundBody
}

// IsSuccess returns true when this image history not found response has a 2xx status code
func (o *ImageHistoryNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image history not found response has a 3xx status code
func (o *ImageHistoryNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image history not found response has a 4xx status code
func (o *ImageHistoryNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this image history not found response has a 5xx status code
func (o *ImageHistoryNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this image history not found response a status code equal to that given
func (o *ImageHistoryNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ImageHistoryNotFound) Error() string {
	return fmt.Sprintf("[GET /images/{name}/history][%d] imageHistoryNotFound  %+v", 404, o.Payload)
}

func (o *ImageHistoryNotFound) String() string {
	return fmt.Sprintf("[GET /images/{name}/history][%d] imageHistoryNotFound  %+v", 404, o.Payload)
}

func (o *ImageHistoryNotFound) GetPayload() *ImageHistoryNotFoundBody {
	return o.Payload
}

func (o *ImageHistoryNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageHistoryNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImageHistoryInternalServerError creates a ImageHistoryInternalServerError with default headers values
func NewImageHistoryInternalServerError() *ImageHistoryInternalServerError {
	return &ImageHistoryInternalServerError{}
}

/*
ImageHistoryInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ImageHistoryInternalServerError struct {
	Payload *ImageHistoryInternalServerErrorBody
}

// IsSuccess returns true when this image history internal server error response has a 2xx status code
func (o *ImageHistoryInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image history internal server error response has a 3xx status code
func (o *ImageHistoryInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image history internal server error response has a 4xx status code
func (o *ImageHistoryInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this image history internal server error response has a 5xx status code
func (o *ImageHistoryInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this image history internal server error response a status code equal to that given
func (o *ImageHistoryInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ImageHistoryInternalServerError) Error() string {
	return fmt.Sprintf("[GET /images/{name}/history][%d] imageHistoryInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageHistoryInternalServerError) String() string {
	return fmt.Sprintf("[GET /images/{name}/history][%d] imageHistoryInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageHistoryInternalServerError) GetPayload() *ImageHistoryInternalServerErrorBody {
	return o.Payload
}

func (o *ImageHistoryInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageHistoryInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ImageHistoryInternalServerErrorBody image history internal server error body
swagger:model ImageHistoryInternalServerErrorBody
*/
type ImageHistoryInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image history internal server error body
func (o *ImageHistoryInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image history internal server error body based on context it is used
func (o *ImageHistoryInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageHistoryInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageHistoryInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ImageHistoryInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ImageHistoryNotFoundBody image history not found body
swagger:model ImageHistoryNotFoundBody
*/
type ImageHistoryNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image history not found body
func (o *ImageHistoryNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image history not found body based on context it is used
func (o *ImageHistoryNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageHistoryNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageHistoryNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ImageHistoryNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ImageHistoryOKBody image history o k body
swagger:model ImageHistoryOKBody
*/
type ImageHistoryOKBody struct {

	// comment
	Comment string `json:"Comment,omitempty"`

	// created
	Created int64 `json:"Created,omitempty"`

	// created by
	CreatedBy string `json:"CreatedBy,omitempty"`

	// ID
	ID string `json:"Id,omitempty"`

	// size
	Size int64 `json:"Size,omitempty"`

	// tags
	Tags []string `json:"Tags"`
}

// Validate validates this image history o k body
func (o *ImageHistoryOKBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image history o k body based on context it is used
func (o *ImageHistoryOKBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageHistoryOKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageHistoryOKBody) UnmarshalBinary(b []byte) error {
	var res ImageHistoryOKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
