// Code generated by go-swagger; DO NOT EDIT.

package manifests

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// ManifestInspectLibpodReader is a Reader for the ManifestInspectLibpod structure.
type ManifestInspectLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ManifestInspectLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewManifestInspectLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewManifestInspectLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewManifestInspectLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewManifestInspectLibpodOK creates a ManifestInspectLibpodOK with default headers values
func NewManifestInspectLibpodOK() *ManifestInspectLibpodOK {
	return &ManifestInspectLibpodOK{}
}

/*
ManifestInspectLibpodOK describes a response with status code 200, with default header values.

Inspect Manifest
*/
type ManifestInspectLibpodOK struct {
	Payload *models.Schema2List
}

// IsSuccess returns true when this manifest inspect libpod o k response has a 2xx status code
func (o *ManifestInspectLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this manifest inspect libpod o k response has a 3xx status code
func (o *ManifestInspectLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this manifest inspect libpod o k response has a 4xx status code
func (o *ManifestInspectLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this manifest inspect libpod o k response has a 5xx status code
func (o *ManifestInspectLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this manifest inspect libpod o k response a status code equal to that given
func (o *ManifestInspectLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *ManifestInspectLibpodOK) Error() string {
	return fmt.Sprintf("[GET /libpod/manifests/{name}/json][%d] manifestInspectLibpodOK  %+v", 200, o.Payload)
}

func (o *ManifestInspectLibpodOK) String() string {
	return fmt.Sprintf("[GET /libpod/manifests/{name}/json][%d] manifestInspectLibpodOK  %+v", 200, o.Payload)
}

func (o *ManifestInspectLibpodOK) GetPayload() *models.Schema2List {
	return o.Payload
}

func (o *ManifestInspectLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Schema2List)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewManifestInspectLibpodNotFound creates a ManifestInspectLibpodNotFound with default headers values
func NewManifestInspectLibpodNotFound() *ManifestInspectLibpodNotFound {
	return &ManifestInspectLibpodNotFound{}
}

/*
ManifestInspectLibpodNotFound describes a response with status code 404, with default header values.

No such manifest
*/
type ManifestInspectLibpodNotFound struct {
	Payload *ManifestInspectLibpodNotFoundBody
}

// IsSuccess returns true when this manifest inspect libpod not found response has a 2xx status code
func (o *ManifestInspectLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this manifest inspect libpod not found response has a 3xx status code
func (o *ManifestInspectLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this manifest inspect libpod not found response has a 4xx status code
func (o *ManifestInspectLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this manifest inspect libpod not found response has a 5xx status code
func (o *ManifestInspectLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this manifest inspect libpod not found response a status code equal to that given
func (o *ManifestInspectLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ManifestInspectLibpodNotFound) Error() string {
	return fmt.Sprintf("[GET /libpod/manifests/{name}/json][%d] manifestInspectLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ManifestInspectLibpodNotFound) String() string {
	return fmt.Sprintf("[GET /libpod/manifests/{name}/json][%d] manifestInspectLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ManifestInspectLibpodNotFound) GetPayload() *ManifestInspectLibpodNotFoundBody {
	return o.Payload
}

func (o *ManifestInspectLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ManifestInspectLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewManifestInspectLibpodInternalServerError creates a ManifestInspectLibpodInternalServerError with default headers values
func NewManifestInspectLibpodInternalServerError() *ManifestInspectLibpodInternalServerError {
	return &ManifestInspectLibpodInternalServerError{}
}

/*
ManifestInspectLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ManifestInspectLibpodInternalServerError struct {
	Payload *ManifestInspectLibpodInternalServerErrorBody
}

// IsSuccess returns true when this manifest inspect libpod internal server error response has a 2xx status code
func (o *ManifestInspectLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this manifest inspect libpod internal server error response has a 3xx status code
func (o *ManifestInspectLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this manifest inspect libpod internal server error response has a 4xx status code
func (o *ManifestInspectLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this manifest inspect libpod internal server error response has a 5xx status code
func (o *ManifestInspectLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this manifest inspect libpod internal server error response a status code equal to that given
func (o *ManifestInspectLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ManifestInspectLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[GET /libpod/manifests/{name}/json][%d] manifestInspectLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ManifestInspectLibpodInternalServerError) String() string {
	return fmt.Sprintf("[GET /libpod/manifests/{name}/json][%d] manifestInspectLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ManifestInspectLibpodInternalServerError) GetPayload() *ManifestInspectLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ManifestInspectLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ManifestInspectLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ManifestInspectLibpodInternalServerErrorBody manifest inspect libpod internal server error body
swagger:model ManifestInspectLibpodInternalServerErrorBody
*/
type ManifestInspectLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this manifest inspect libpod internal server error body
func (o *ManifestInspectLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this manifest inspect libpod internal server error body based on context it is used
func (o *ManifestInspectLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ManifestInspectLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ManifestInspectLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ManifestInspectLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ManifestInspectLibpodNotFoundBody manifest inspect libpod not found body
swagger:model ManifestInspectLibpodNotFoundBody
*/
type ManifestInspectLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this manifest inspect libpod not found body
func (o *ManifestInspectLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this manifest inspect libpod not found body based on context it is used
func (o *ManifestInspectLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ManifestInspectLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ManifestInspectLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ManifestInspectLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
