// Code generated by go-swagger; DO NOT EDIT.

package networks

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NetworkConnectLibpodReader is a Reader for the NetworkConnectLibpod structure.
type NetworkConnectLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NetworkConnectLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNetworkConnectLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewNetworkConnectLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewNetworkConnectLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewNetworkConnectLibpodOK creates a NetworkConnectLibpodOK with default headers values
func NewNetworkConnectLibpodOK() *NetworkConnectLibpodOK {
	return &NetworkConnectLibpodOK{}
}

/*
NetworkConnectLibpodOK describes a response with status code 200, with default header values.

OK
*/
type NetworkConnectLibpodOK struct {
}

// IsSuccess returns true when this network connect libpod o k response has a 2xx status code
func (o *NetworkConnectLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this network connect libpod o k response has a 3xx status code
func (o *NetworkConnectLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network connect libpod o k response has a 4xx status code
func (o *NetworkConnectLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this network connect libpod o k response has a 5xx status code
func (o *NetworkConnectLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this network connect libpod o k response a status code equal to that given
func (o *NetworkConnectLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *NetworkConnectLibpodOK) Error() string {
	return fmt.Sprintf("[POST /libpod/networks/{name}/connect][%d] networkConnectLibpodOK ", 200)
}

func (o *NetworkConnectLibpodOK) String() string {
	return fmt.Sprintf("[POST /libpod/networks/{name}/connect][%d] networkConnectLibpodOK ", 200)
}

func (o *NetworkConnectLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNetworkConnectLibpodNotFound creates a NetworkConnectLibpodNotFound with default headers values
func NewNetworkConnectLibpodNotFound() *NetworkConnectLibpodNotFound {
	return &NetworkConnectLibpodNotFound{}
}

/*
NetworkConnectLibpodNotFound describes a response with status code 404, with default header values.

No such network
*/
type NetworkConnectLibpodNotFound struct {
	Payload *NetworkConnectLibpodNotFoundBody
}

// IsSuccess returns true when this network connect libpod not found response has a 2xx status code
func (o *NetworkConnectLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this network connect libpod not found response has a 3xx status code
func (o *NetworkConnectLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network connect libpod not found response has a 4xx status code
func (o *NetworkConnectLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this network connect libpod not found response has a 5xx status code
func (o *NetworkConnectLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this network connect libpod not found response a status code equal to that given
func (o *NetworkConnectLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *NetworkConnectLibpodNotFound) Error() string {
	return fmt.Sprintf("[POST /libpod/networks/{name}/connect][%d] networkConnectLibpodNotFound  %+v", 404, o.Payload)
}

func (o *NetworkConnectLibpodNotFound) String() string {
	return fmt.Sprintf("[POST /libpod/networks/{name}/connect][%d] networkConnectLibpodNotFound  %+v", 404, o.Payload)
}

func (o *NetworkConnectLibpodNotFound) GetPayload() *NetworkConnectLibpodNotFoundBody {
	return o.Payload
}

func (o *NetworkConnectLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(NetworkConnectLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNetworkConnectLibpodInternalServerError creates a NetworkConnectLibpodInternalServerError with default headers values
func NewNetworkConnectLibpodInternalServerError() *NetworkConnectLibpodInternalServerError {
	return &NetworkConnectLibpodInternalServerError{}
}

/*
NetworkConnectLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type NetworkConnectLibpodInternalServerError struct {
	Payload *NetworkConnectLibpodInternalServerErrorBody
}

// IsSuccess returns true when this network connect libpod internal server error response has a 2xx status code
func (o *NetworkConnectLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this network connect libpod internal server error response has a 3xx status code
func (o *NetworkConnectLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network connect libpod internal server error response has a 4xx status code
func (o *NetworkConnectLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this network connect libpod internal server error response has a 5xx status code
func (o *NetworkConnectLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this network connect libpod internal server error response a status code equal to that given
func (o *NetworkConnectLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *NetworkConnectLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[POST /libpod/networks/{name}/connect][%d] networkConnectLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *NetworkConnectLibpodInternalServerError) String() string {
	return fmt.Sprintf("[POST /libpod/networks/{name}/connect][%d] networkConnectLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *NetworkConnectLibpodInternalServerError) GetPayload() *NetworkConnectLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *NetworkConnectLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(NetworkConnectLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NetworkConnectLibpodInternalServerErrorBody network connect libpod internal server error body
swagger:model NetworkConnectLibpodInternalServerErrorBody
*/
type NetworkConnectLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this network connect libpod internal server error body
func (o *NetworkConnectLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this network connect libpod internal server error body based on context it is used
func (o *NetworkConnectLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NetworkConnectLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NetworkConnectLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res NetworkConnectLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NetworkConnectLibpodNotFoundBody network connect libpod not found body
swagger:model NetworkConnectLibpodNotFoundBody
*/
type NetworkConnectLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this network connect libpod not found body
func (o *NetworkConnectLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this network connect libpod not found body based on context it is used
func (o *NetworkConnectLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NetworkConnectLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NetworkConnectLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res NetworkConnectLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
