// Code generated by go-swagger; DO NOT EDIT.

package networks

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewNetworkPruneLibpodParams creates a new NetworkPruneLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNetworkPruneLibpodParams() *NetworkPruneLibpodParams {
	return &NetworkPruneLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNetworkPruneLibpodParamsWithTimeout creates a new NetworkPruneLibpodParams object
// with the ability to set a timeout on a request.
func NewNetworkPruneLibpodParamsWithTimeout(timeout time.Duration) *NetworkPruneLibpodParams {
	return &NetworkPruneLibpodParams{
		timeout: timeout,
	}
}

// NewNetworkPruneLibpodParamsWithContext creates a new NetworkPruneLibpodParams object
// with the ability to set a context for a request.
func NewNetworkPruneLibpodParamsWithContext(ctx context.Context) *NetworkPruneLibpodParams {
	return &NetworkPruneLibpodParams{
		Context: ctx,
	}
}

// NewNetworkPruneLibpodParamsWithHTTPClient creates a new NetworkPruneLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewNetworkPruneLibpodParamsWithHTTPClient(client *http.Client) *NetworkPruneLibpodParams {
	return &NetworkPruneLibpodParams{
		HTTPClient: client,
	}
}

/*
NetworkPruneLibpodParams contains all the parameters to send to the API endpoint

	for the network prune libpod operation.

	Typically these are written to a http.Request.
*/
type NetworkPruneLibpodParams struct {

	/* Filters.

	     Filters to process on the prune list, encoded as JSON (a `map[string][]string`).
	Available filters:
	  - `until=<timestamp>` Prune networks created before this timestamp. The `<timestamp>` can be Unix timestamps, date formatted timestamps, or Go duration strings (e.g. `10m`, `1h30m`) computed relative to the daemon machine’s time.
	  - `label` (`label=<key>`, `label=<key>=<value>`, `label!=<key>`, or `label!=<key>=<value>`) Prune networks with (or without, in case `label!=...` is used) the specified labels.

	*/
	Filters *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the network prune libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkPruneLibpodParams) WithDefaults() *NetworkPruneLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the network prune libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkPruneLibpodParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the network prune libpod params
func (o *NetworkPruneLibpodParams) WithTimeout(timeout time.Duration) *NetworkPruneLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the network prune libpod params
func (o *NetworkPruneLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the network prune libpod params
func (o *NetworkPruneLibpodParams) WithContext(ctx context.Context) *NetworkPruneLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the network prune libpod params
func (o *NetworkPruneLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the network prune libpod params
func (o *NetworkPruneLibpodParams) WithHTTPClient(client *http.Client) *NetworkPruneLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the network prune libpod params
func (o *NetworkPruneLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilters adds the filters to the network prune libpod params
func (o *NetworkPruneLibpodParams) WithFilters(filters *string) *NetworkPruneLibpodParams {
	o.SetFilters(filters)
	return o
}

// SetFilters adds the filters to the network prune libpod params
func (o *NetworkPruneLibpodParams) SetFilters(filters *string) {
	o.Filters = filters
}

// WriteToRequest writes these params to a swagger request
func (o *NetworkPruneLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filters != nil {

		// query param filters
		var qrFilters string

		if o.Filters != nil {
			qrFilters = *o.Filters
		}
		qFilters := qrFilters
		if qFilters != "" {

			if err := r.SetQueryParam("filters", qFilters); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
