// Code generated by go-swagger; DO NOT EDIT.

package networks_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// NetworkInspectReader is a Reader for the NetworkInspect structure.
type NetworkInspectReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NetworkInspectReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNetworkInspectOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewNetworkInspectNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewNetworkInspectInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewNetworkInspectOK creates a NetworkInspectOK with default headers values
func NewNetworkInspectOK() *NetworkInspectOK {
	return &NetworkInspectOK{}
}

/*
NetworkInspectOK describes a response with status code 200, with default header values.

Network inspect
*/
type NetworkInspectOK struct {
	Payload *models.NetworkResource
}

// IsSuccess returns true when this network inspect o k response has a 2xx status code
func (o *NetworkInspectOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this network inspect o k response has a 3xx status code
func (o *NetworkInspectOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network inspect o k response has a 4xx status code
func (o *NetworkInspectOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this network inspect o k response has a 5xx status code
func (o *NetworkInspectOK) IsServerError() bool {
	return false
}

// IsCode returns true when this network inspect o k response a status code equal to that given
func (o *NetworkInspectOK) IsCode(code int) bool {
	return code == 200
}

func (o *NetworkInspectOK) Error() string {
	return fmt.Sprintf("[GET /networks/{name}][%d] networkInspectOK  %+v", 200, o.Payload)
}

func (o *NetworkInspectOK) String() string {
	return fmt.Sprintf("[GET /networks/{name}][%d] networkInspectOK  %+v", 200, o.Payload)
}

func (o *NetworkInspectOK) GetPayload() *models.NetworkResource {
	return o.Payload
}

func (o *NetworkInspectOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.NetworkResource)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNetworkInspectNotFound creates a NetworkInspectNotFound with default headers values
func NewNetworkInspectNotFound() *NetworkInspectNotFound {
	return &NetworkInspectNotFound{}
}

/*
NetworkInspectNotFound describes a response with status code 404, with default header values.

No such network
*/
type NetworkInspectNotFound struct {
	Payload *NetworkInspectNotFoundBody
}

// IsSuccess returns true when this network inspect not found response has a 2xx status code
func (o *NetworkInspectNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this network inspect not found response has a 3xx status code
func (o *NetworkInspectNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network inspect not found response has a 4xx status code
func (o *NetworkInspectNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this network inspect not found response has a 5xx status code
func (o *NetworkInspectNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this network inspect not found response a status code equal to that given
func (o *NetworkInspectNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *NetworkInspectNotFound) Error() string {
	return fmt.Sprintf("[GET /networks/{name}][%d] networkInspectNotFound  %+v", 404, o.Payload)
}

func (o *NetworkInspectNotFound) String() string {
	return fmt.Sprintf("[GET /networks/{name}][%d] networkInspectNotFound  %+v", 404, o.Payload)
}

func (o *NetworkInspectNotFound) GetPayload() *NetworkInspectNotFoundBody {
	return o.Payload
}

func (o *NetworkInspectNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(NetworkInspectNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNetworkInspectInternalServerError creates a NetworkInspectInternalServerError with default headers values
func NewNetworkInspectInternalServerError() *NetworkInspectInternalServerError {
	return &NetworkInspectInternalServerError{}
}

/*
NetworkInspectInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type NetworkInspectInternalServerError struct {
	Payload *NetworkInspectInternalServerErrorBody
}

// IsSuccess returns true when this network inspect internal server error response has a 2xx status code
func (o *NetworkInspectInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this network inspect internal server error response has a 3xx status code
func (o *NetworkInspectInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network inspect internal server error response has a 4xx status code
func (o *NetworkInspectInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this network inspect internal server error response has a 5xx status code
func (o *NetworkInspectInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this network inspect internal server error response a status code equal to that given
func (o *NetworkInspectInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *NetworkInspectInternalServerError) Error() string {
	return fmt.Sprintf("[GET /networks/{name}][%d] networkInspectInternalServerError  %+v", 500, o.Payload)
}

func (o *NetworkInspectInternalServerError) String() string {
	return fmt.Sprintf("[GET /networks/{name}][%d] networkInspectInternalServerError  %+v", 500, o.Payload)
}

func (o *NetworkInspectInternalServerError) GetPayload() *NetworkInspectInternalServerErrorBody {
	return o.Payload
}

func (o *NetworkInspectInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(NetworkInspectInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NetworkInspectInternalServerErrorBody network inspect internal server error body
swagger:model NetworkInspectInternalServerErrorBody
*/
type NetworkInspectInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this network inspect internal server error body
func (o *NetworkInspectInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this network inspect internal server error body based on context it is used
func (o *NetworkInspectInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NetworkInspectInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NetworkInspectInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res NetworkInspectInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NetworkInspectNotFoundBody network inspect not found body
swagger:model NetworkInspectNotFoundBody
*/
type NetworkInspectNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this network inspect not found body
func (o *NetworkInspectNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this network inspect not found body based on context it is used
func (o *NetworkInspectNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NetworkInspectNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NetworkInspectNotFoundBody) UnmarshalBinary(b []byte) error {
	var res NetworkInspectNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
