// Code generated by go-swagger; DO NOT EDIT.

package secrets

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecretDeleteLibpodParams creates a new SecretDeleteLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecretDeleteLibpodParams() *SecretDeleteLibpodParams {
	return &SecretDeleteLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecretDeleteLibpodParamsWithTimeout creates a new SecretDeleteLibpodParams object
// with the ability to set a timeout on a request.
func NewSecretDeleteLibpodParamsWithTimeout(timeout time.Duration) *SecretDeleteLibpodParams {
	return &SecretDeleteLibpodParams{
		timeout: timeout,
	}
}

// NewSecretDeleteLibpodParamsWithContext creates a new SecretDeleteLibpodParams object
// with the ability to set a context for a request.
func NewSecretDeleteLibpodParamsWithContext(ctx context.Context) *SecretDeleteLibpodParams {
	return &SecretDeleteLibpodParams{
		Context: ctx,
	}
}

// NewSecretDeleteLibpodParamsWithHTTPClient creates a new SecretDeleteLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecretDeleteLibpodParamsWithHTTPClient(client *http.Client) *SecretDeleteLibpodParams {
	return &SecretDeleteLibpodParams{
		HTTPClient: client,
	}
}

/*
SecretDeleteLibpodParams contains all the parameters to send to the API endpoint

	for the secret delete libpod operation.

	Typically these are written to a http.Request.
*/
type SecretDeleteLibpodParams struct {

	/* All.

	   Remove all secrets
	*/
	All *bool

	/* Name.

	   the name or ID of the secret
	*/
	Name string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the secret delete libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecretDeleteLibpodParams) WithDefaults() *SecretDeleteLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the secret delete libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecretDeleteLibpodParams) SetDefaults() {
	var (
		allDefault = bool(false)
	)

	val := SecretDeleteLibpodParams{
		All: &allDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the secret delete libpod params
func (o *SecretDeleteLibpodParams) WithTimeout(timeout time.Duration) *SecretDeleteLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the secret delete libpod params
func (o *SecretDeleteLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the secret delete libpod params
func (o *SecretDeleteLibpodParams) WithContext(ctx context.Context) *SecretDeleteLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the secret delete libpod params
func (o *SecretDeleteLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the secret delete libpod params
func (o *SecretDeleteLibpodParams) WithHTTPClient(client *http.Client) *SecretDeleteLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the secret delete libpod params
func (o *SecretDeleteLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAll adds the all to the secret delete libpod params
func (o *SecretDeleteLibpodParams) WithAll(all *bool) *SecretDeleteLibpodParams {
	o.SetAll(all)
	return o
}

// SetAll adds the all to the secret delete libpod params
func (o *SecretDeleteLibpodParams) SetAll(all *bool) {
	o.All = all
}

// WithName adds the name to the secret delete libpod params
func (o *SecretDeleteLibpodParams) WithName(name string) *SecretDeleteLibpodParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the secret delete libpod params
func (o *SecretDeleteLibpodParams) SetName(name string) {
	o.Name = name
}

// WriteToRequest writes these params to a swagger request
func (o *SecretDeleteLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.All != nil {

		// query param all
		var qrAll bool

		if o.All != nil {
			qrAll = *o.All
		}
		qAll := swag.FormatBool(qrAll)
		if qAll != "" {

			if err := r.SetQueryParam("all", qAll); err != nil {
				return err
			}
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
