// Code generated by go-swagger; DO NOT EDIT.

package system

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// SystemDataUsageLibpodReader is a Reader for the SystemDataUsageLibpod structure.
type SystemDataUsageLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SystemDataUsageLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSystemDataUsageLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 500:
		result := NewSystemDataUsageLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewSystemDataUsageLibpodOK creates a SystemDataUsageLibpodOK with default headers values
func NewSystemDataUsageLibpodOK() *SystemDataUsageLibpodOK {
	return &SystemDataUsageLibpodOK{}
}

/*
SystemDataUsageLibpodOK describes a response with status code 200, with default header values.

Disk usage
*/
type SystemDataUsageLibpodOK struct {
	Payload *SystemDataUsageLibpodOKBody
}

// IsSuccess returns true when this system data usage libpod o k response has a 2xx status code
func (o *SystemDataUsageLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this system data usage libpod o k response has a 3xx status code
func (o *SystemDataUsageLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this system data usage libpod o k response has a 4xx status code
func (o *SystemDataUsageLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this system data usage libpod o k response has a 5xx status code
func (o *SystemDataUsageLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this system data usage libpod o k response a status code equal to that given
func (o *SystemDataUsageLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *SystemDataUsageLibpodOK) Error() string {
	return fmt.Sprintf("[GET /libpod/system/df][%d] systemDataUsageLibpodOK  %+v", 200, o.Payload)
}

func (o *SystemDataUsageLibpodOK) String() string {
	return fmt.Sprintf("[GET /libpod/system/df][%d] systemDataUsageLibpodOK  %+v", 200, o.Payload)
}

func (o *SystemDataUsageLibpodOK) GetPayload() *SystemDataUsageLibpodOKBody {
	return o.Payload
}

func (o *SystemDataUsageLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(SystemDataUsageLibpodOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSystemDataUsageLibpodInternalServerError creates a SystemDataUsageLibpodInternalServerError with default headers values
func NewSystemDataUsageLibpodInternalServerError() *SystemDataUsageLibpodInternalServerError {
	return &SystemDataUsageLibpodInternalServerError{}
}

/*
SystemDataUsageLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type SystemDataUsageLibpodInternalServerError struct {
	Payload *SystemDataUsageLibpodInternalServerErrorBody
}

// IsSuccess returns true when this system data usage libpod internal server error response has a 2xx status code
func (o *SystemDataUsageLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this system data usage libpod internal server error response has a 3xx status code
func (o *SystemDataUsageLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this system data usage libpod internal server error response has a 4xx status code
func (o *SystemDataUsageLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this system data usage libpod internal server error response has a 5xx status code
func (o *SystemDataUsageLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this system data usage libpod internal server error response a status code equal to that given
func (o *SystemDataUsageLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *SystemDataUsageLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[GET /libpod/system/df][%d] systemDataUsageLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *SystemDataUsageLibpodInternalServerError) String() string {
	return fmt.Sprintf("[GET /libpod/system/df][%d] systemDataUsageLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *SystemDataUsageLibpodInternalServerError) GetPayload() *SystemDataUsageLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *SystemDataUsageLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(SystemDataUsageLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SystemDataUsageLibpodInternalServerErrorBody system data usage libpod internal server error body
swagger:model SystemDataUsageLibpodInternalServerErrorBody
*/
type SystemDataUsageLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this system data usage libpod internal server error body
func (o *SystemDataUsageLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this system data usage libpod internal server error body based on context it is used
func (o *SystemDataUsageLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *SystemDataUsageLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SystemDataUsageLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res SystemDataUsageLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SystemDataUsageLibpodOKBody system data usage libpod o k body
swagger:model SystemDataUsageLibpodOKBody
*/
type SystemDataUsageLibpodOKBody struct {

	// containers
	Containers []*models.SystemDfContainerReport `json:"Containers"`

	// images
	Images []*models.SystemDfImageReport `json:"Images"`

	// volumes
	Volumes []*models.SystemDfVolumeReport `json:"Volumes"`
}

// Validate validates this system data usage libpod o k body
func (o *SystemDataUsageLibpodOKBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateContainers(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateImages(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolumes(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SystemDataUsageLibpodOKBody) validateContainers(formats strfmt.Registry) error {
	if swag.IsZero(o.Containers) { // not required
		return nil
	}

	for i := 0; i < len(o.Containers); i++ {
		if swag.IsZero(o.Containers[i]) { // not required
			continue
		}

		if o.Containers[i] != nil {
			if err := o.Containers[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("systemDataUsageLibpodOK" + "." + "Containers" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("systemDataUsageLibpodOK" + "." + "Containers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SystemDataUsageLibpodOKBody) validateImages(formats strfmt.Registry) error {
	if swag.IsZero(o.Images) { // not required
		return nil
	}

	for i := 0; i < len(o.Images); i++ {
		if swag.IsZero(o.Images[i]) { // not required
			continue
		}

		if o.Images[i] != nil {
			if err := o.Images[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("systemDataUsageLibpodOK" + "." + "Images" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("systemDataUsageLibpodOK" + "." + "Images" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SystemDataUsageLibpodOKBody) validateVolumes(formats strfmt.Registry) error {
	if swag.IsZero(o.Volumes) { // not required
		return nil
	}

	for i := 0; i < len(o.Volumes); i++ {
		if swag.IsZero(o.Volumes[i]) { // not required
			continue
		}

		if o.Volumes[i] != nil {
			if err := o.Volumes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("systemDataUsageLibpodOK" + "." + "Volumes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("systemDataUsageLibpodOK" + "." + "Volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this system data usage libpod o k body based on the context it is used
func (o *SystemDataUsageLibpodOKBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateContainers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateImages(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SystemDataUsageLibpodOKBody) contextValidateContainers(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Containers); i++ {

		if o.Containers[i] != nil {
			if err := o.Containers[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("systemDataUsageLibpodOK" + "." + "Containers" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("systemDataUsageLibpodOK" + "." + "Containers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SystemDataUsageLibpodOKBody) contextValidateImages(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Images); i++ {

		if o.Images[i] != nil {
			if err := o.Images[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("systemDataUsageLibpodOK" + "." + "Images" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("systemDataUsageLibpodOK" + "." + "Images" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SystemDataUsageLibpodOKBody) contextValidateVolumes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Volumes); i++ {

		if o.Volumes[i] != nil {
			if err := o.Volumes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("systemDataUsageLibpodOK" + "." + "Volumes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("systemDataUsageLibpodOK" + "." + "Volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SystemDataUsageLibpodOKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SystemDataUsageLibpodOKBody) UnmarshalBinary(b []byte) error {
	var res SystemDataUsageLibpodOKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
