// Code generated by go-swagger; DO NOT EDIT.

package images_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ImageBuildReader is a Reader for the ImageBuild structure.
type ImageBuildReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ImageBuildReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewImageBuildOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewImageBuildBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewImageBuildInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewImageBuildOK creates a ImageBuildOK with default headers values
func NewImageBuildOK() *ImageBuildOK {
	return &ImageBuildOK{}
}

/*
ImageBuildOK describes a response with status code 200, with default header values.

OK (As of version 1.xx)
*/
type ImageBuildOK struct {
	Payload *ImageBuildOKBody
}

// IsSuccess returns true when this image build o k response has a 2xx status code
func (o *ImageBuildOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this image build o k response has a 3xx status code
func (o *ImageBuildOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image build o k response has a 4xx status code
func (o *ImageBuildOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this image build o k response has a 5xx status code
func (o *ImageBuildOK) IsServerError() bool {
	return false
}

// IsCode returns true when this image build o k response a status code equal to that given
func (o *ImageBuildOK) IsCode(code int) bool {
	return code == 200
}

func (o *ImageBuildOK) Error() string {
	return fmt.Sprintf("[POST /build][%d] imageBuildOK  %+v", 200, o.Payload)
}

func (o *ImageBuildOK) String() string {
	return fmt.Sprintf("[POST /build][%d] imageBuildOK  %+v", 200, o.Payload)
}

func (o *ImageBuildOK) GetPayload() *ImageBuildOKBody {
	return o.Payload
}

func (o *ImageBuildOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageBuildOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImageBuildBadRequest creates a ImageBuildBadRequest with default headers values
func NewImageBuildBadRequest() *ImageBuildBadRequest {
	return &ImageBuildBadRequest{}
}

/*
ImageBuildBadRequest describes a response with status code 400, with default header values.

Bad parameter in request
*/
type ImageBuildBadRequest struct {
	Payload *ImageBuildBadRequestBody
}

// IsSuccess returns true when this image build bad request response has a 2xx status code
func (o *ImageBuildBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image build bad request response has a 3xx status code
func (o *ImageBuildBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image build bad request response has a 4xx status code
func (o *ImageBuildBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this image build bad request response has a 5xx status code
func (o *ImageBuildBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this image build bad request response a status code equal to that given
func (o *ImageBuildBadRequest) IsCode(code int) bool {
	return code == 400
}

func (o *ImageBuildBadRequest) Error() string {
	return fmt.Sprintf("[POST /build][%d] imageBuildBadRequest  %+v", 400, o.Payload)
}

func (o *ImageBuildBadRequest) String() string {
	return fmt.Sprintf("[POST /build][%d] imageBuildBadRequest  %+v", 400, o.Payload)
}

func (o *ImageBuildBadRequest) GetPayload() *ImageBuildBadRequestBody {
	return o.Payload
}

func (o *ImageBuildBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageBuildBadRequestBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImageBuildInternalServerError creates a ImageBuildInternalServerError with default headers values
func NewImageBuildInternalServerError() *ImageBuildInternalServerError {
	return &ImageBuildInternalServerError{}
}

/*
ImageBuildInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ImageBuildInternalServerError struct {
	Payload *ImageBuildInternalServerErrorBody
}

// IsSuccess returns true when this image build internal server error response has a 2xx status code
func (o *ImageBuildInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image build internal server error response has a 3xx status code
func (o *ImageBuildInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image build internal server error response has a 4xx status code
func (o *ImageBuildInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this image build internal server error response has a 5xx status code
func (o *ImageBuildInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this image build internal server error response a status code equal to that given
func (o *ImageBuildInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ImageBuildInternalServerError) Error() string {
	return fmt.Sprintf("[POST /build][%d] imageBuildInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageBuildInternalServerError) String() string {
	return fmt.Sprintf("[POST /build][%d] imageBuildInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageBuildInternalServerError) GetPayload() *ImageBuildInternalServerErrorBody {
	return o.Payload
}

func (o *ImageBuildInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageBuildInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ImageBuildBadRequestBody image build bad request body
swagger:model ImageBuildBadRequestBody
*/
type ImageBuildBadRequestBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image build bad request body
func (o *ImageBuildBadRequestBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image build bad request body based on context it is used
func (o *ImageBuildBadRequestBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageBuildBadRequestBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageBuildBadRequestBody) UnmarshalBinary(b []byte) error {
	var res ImageBuildBadRequestBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ImageBuildInternalServerErrorBody image build internal server error body
swagger:model ImageBuildInternalServerErrorBody
*/
type ImageBuildInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image build internal server error body
func (o *ImageBuildInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image build internal server error body based on context it is used
func (o *ImageBuildInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageBuildInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageBuildInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ImageBuildInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ImageBuildOKBody image build o k body
swagger:model ImageBuildOKBody
*/
type ImageBuildOKBody struct {

	// output from build process
	// Example: (build details...)\nSuccessfully built 8ba084515c724cbf90d447a63600c0a6\nSuccessfully tagged your_image:latest\n
	// Required: true
	Stream *string `json:"stream"`
}

// Validate validates this image build o k body
func (o *ImageBuildOKBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateStream(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ImageBuildOKBody) validateStream(formats strfmt.Registry) error {

	if err := validate.Required("imageBuildOK"+"."+"stream", "body", o.Stream); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this image build o k body based on context it is used
func (o *ImageBuildOKBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageBuildOKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageBuildOKBody) UnmarshalBinary(b []byte) error {
	var res ImageBuildOKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
