// Code generated by go-swagger; DO NOT EDIT.

package networks_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NetworkPruneReader is a Reader for the NetworkPrune structure.
type NetworkPruneReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NetworkPruneReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNetworkPruneOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 500:
		result := NewNetworkPruneInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewNetworkPruneOK creates a NetworkPruneOK with default headers values
func NewNetworkPruneOK() *NetworkPruneOK {
	return &NetworkPruneOK{}
}

/*
NetworkPruneOK describes a response with status code 200, with default header values.

OK
*/
type NetworkPruneOK struct {
	Payload *NetworkPruneOKBody
}

// IsSuccess returns true when this network prune o k response has a 2xx status code
func (o *NetworkPruneOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this network prune o k response has a 3xx status code
func (o *NetworkPruneOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network prune o k response has a 4xx status code
func (o *NetworkPruneOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this network prune o k response has a 5xx status code
func (o *NetworkPruneOK) IsServerError() bool {
	return false
}

// IsCode returns true when this network prune o k response a status code equal to that given
func (o *NetworkPruneOK) IsCode(code int) bool {
	return code == 200
}

func (o *NetworkPruneOK) Error() string {
	return fmt.Sprintf("[POST /networks/prune][%d] networkPruneOK  %+v", 200, o.Payload)
}

func (o *NetworkPruneOK) String() string {
	return fmt.Sprintf("[POST /networks/prune][%d] networkPruneOK  %+v", 200, o.Payload)
}

func (o *NetworkPruneOK) GetPayload() *NetworkPruneOKBody {
	return o.Payload
}

func (o *NetworkPruneOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(NetworkPruneOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNetworkPruneInternalServerError creates a NetworkPruneInternalServerError with default headers values
func NewNetworkPruneInternalServerError() *NetworkPruneInternalServerError {
	return &NetworkPruneInternalServerError{}
}

/*
NetworkPruneInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type NetworkPruneInternalServerError struct {
	Payload *NetworkPruneInternalServerErrorBody
}

// IsSuccess returns true when this network prune internal server error response has a 2xx status code
func (o *NetworkPruneInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this network prune internal server error response has a 3xx status code
func (o *NetworkPruneInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network prune internal server error response has a 4xx status code
func (o *NetworkPruneInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this network prune internal server error response has a 5xx status code
func (o *NetworkPruneInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this network prune internal server error response a status code equal to that given
func (o *NetworkPruneInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *NetworkPruneInternalServerError) Error() string {
	return fmt.Sprintf("[POST /networks/prune][%d] networkPruneInternalServerError  %+v", 500, o.Payload)
}

func (o *NetworkPruneInternalServerError) String() string {
	return fmt.Sprintf("[POST /networks/prune][%d] networkPruneInternalServerError  %+v", 500, o.Payload)
}

func (o *NetworkPruneInternalServerError) GetPayload() *NetworkPruneInternalServerErrorBody {
	return o.Payload
}

func (o *NetworkPruneInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(NetworkPruneInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NetworkPruneInternalServerErrorBody network prune internal server error body
swagger:model NetworkPruneInternalServerErrorBody
*/
type NetworkPruneInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this network prune internal server error body
func (o *NetworkPruneInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this network prune internal server error body based on context it is used
func (o *NetworkPruneInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NetworkPruneInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NetworkPruneInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res NetworkPruneInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NetworkPruneOKBody network prune o k body
swagger:model NetworkPruneOKBody
*/
type NetworkPruneOKBody struct {

	// networks deleted
	NetworksDeleted []string `json:"NetworksDeleted"`
}

// Validate validates this network prune o k body
func (o *NetworkPruneOKBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this network prune o k body based on context it is used
func (o *NetworkPruneOKBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NetworkPruneOKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NetworkPruneOKBody) UnmarshalBinary(b []byte) error {
	var res NetworkPruneOKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
