// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ListContainer ListContainer describes a container suitable for listing
//
// swagger:model ListContainer
type ListContainer struct {

	// AutoRemove
	AutoRemove bool `json:"AutoRemove,omitempty"`

	// Container command
	Command []string `json:"Command"`

	// Container creation time
	// Format: date-time
	Created strfmt.DateTime `json:"Created,omitempty"`

	// Human-readable container creation time.
	CreatedAt string `json:"CreatedAt,omitempty"`

	// If container has exited, the return code from the command
	ExitCode int32 `json:"ExitCode,omitempty"`

	// If container has exited/stopped
	Exited bool `json:"Exited,omitempty"`

	// Time container exited
	ExitedAt int64 `json:"ExitedAt,omitempty"`

	// The unique identifier for the container
	ID string `json:"Id,omitempty"`

	// Container image
	Image string `json:"Image,omitempty"`

	// Container image ID
	ImageID string `json:"ImageID,omitempty"`

	// If this container is a Pod infra container
	IsInfra bool `json:"IsInfra,omitempty"`

	// Labels for container
	Labels map[string]string `json:"Labels,omitempty"`

	// User volume mounts
	Mounts []string `json:"Mounts"`

	// The names assigned to the container
	Names []string `json:"Names"`

	// namespaces
	Namespaces *ListContainerNamespaces `json:"Namespaces,omitempty"`

	// The network names assigned to the container
	Networks []string `json:"Networks"`

	// The process id of the container
	Pid int64 `json:"Pid,omitempty"`

	// If the container is part of Pod, the Pod ID. Requires the pod
	// boolean to be set
	Pod string `json:"Pod,omitempty"`

	// If the container is part of Pod, the Pod name. Requires the pod
	// boolean to be set
	PodName string `json:"PodName,omitempty"`

	// Port mappings
	Ports []*PortMapping `json:"Ports"`

	// size
	Size *ContainerSize `json:"Size,omitempty"`

	// Time when container started
	StartedAt int64 `json:"StartedAt,omitempty"`

	// State of container
	State string `json:"State,omitempty"`

	// Status is a human-readable approximation of a duration for json output
	Status string `json:"Status,omitempty"`
}

// Validate validates this list container
func (m *ListContainer) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCreated(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNamespaces(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePorts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ListContainer) validateCreated(formats strfmt.Registry) error {
	if swag.IsZero(m.Created) { // not required
		return nil
	}

	if err := validate.FormatOf("Created", "body", "date-time", m.Created.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *ListContainer) validateNamespaces(formats strfmt.Registry) error {
	if swag.IsZero(m.Namespaces) { // not required
		return nil
	}

	if m.Namespaces != nil {
		if err := m.Namespaces.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("Namespaces")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("Namespaces")
			}
			return err
		}
	}

	return nil
}

func (m *ListContainer) validatePorts(formats strfmt.Registry) error {
	if swag.IsZero(m.Ports) { // not required
		return nil
	}

	for i := 0; i < len(m.Ports); i++ {
		if swag.IsZero(m.Ports[i]) { // not required
			continue
		}

		if m.Ports[i] != nil {
			if err := m.Ports[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Ports" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ListContainer) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(m.Size) { // not required
		return nil
	}

	if m.Size != nil {
		if err := m.Size.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("Size")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("Size")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this list container based on the context it is used
func (m *ListContainer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNamespaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePorts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ListContainer) contextValidateNamespaces(ctx context.Context, formats strfmt.Registry) error {

	if m.Namespaces != nil {
		if err := m.Namespaces.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("Namespaces")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("Namespaces")
			}
			return err
		}
	}

	return nil
}

func (m *ListContainer) contextValidatePorts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Ports); i++ {

		if m.Ports[i] != nil {
			if err := m.Ports[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Ports" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ListContainer) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if m.Size != nil {
		if err := m.Size.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("Size")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("Size")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ListContainer) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ListContainer) UnmarshalBinary(b []byte) error {
	var res ListContainer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
