// Code generated by go-swagger; DO NOT EDIT.

package containers_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ContainerArchiveLibpodReader is a Reader for the ContainerArchiveLibpod structure.
type ContainerArchiveLibpodReader struct {
	formats strfmt.Registry
	writer  io.Writer
}

// ReadResponse reads a server response into the received o.
func (o *ContainerArchiveLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewContainerArchiveLibpodOK(o.writer)
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewContainerArchiveLibpodBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewContainerArchiveLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewContainerArchiveLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewContainerArchiveLibpodOK creates a ContainerArchiveLibpodOK with default headers values
func NewContainerArchiveLibpodOK(writer io.Writer) *ContainerArchiveLibpodOK {
	return &ContainerArchiveLibpodOK{

		Payload: writer,
	}
}

/*
ContainerArchiveLibpodOK describes a response with status code 200, with default header values.

no error
*/
type ContainerArchiveLibpodOK struct {
	Payload io.Writer
}

// IsSuccess returns true when this container archive libpod o k response has a 2xx status code
func (o *ContainerArchiveLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this container archive libpod o k response has a 3xx status code
func (o *ContainerArchiveLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container archive libpod o k response has a 4xx status code
func (o *ContainerArchiveLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this container archive libpod o k response has a 5xx status code
func (o *ContainerArchiveLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this container archive libpod o k response a status code equal to that given
func (o *ContainerArchiveLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *ContainerArchiveLibpodOK) Error() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/archive][%d] containerArchiveLibpodOK  %+v", 200, o.Payload)
}

func (o *ContainerArchiveLibpodOK) String() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/archive][%d] containerArchiveLibpodOK  %+v", 200, o.Payload)
}

func (o *ContainerArchiveLibpodOK) GetPayload() io.Writer {
	return o.Payload
}

func (o *ContainerArchiveLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerArchiveLibpodBadRequest creates a ContainerArchiveLibpodBadRequest with default headers values
func NewContainerArchiveLibpodBadRequest() *ContainerArchiveLibpodBadRequest {
	return &ContainerArchiveLibpodBadRequest{}
}

/*
ContainerArchiveLibpodBadRequest describes a response with status code 400, with default header values.

Bad parameter in request
*/
type ContainerArchiveLibpodBadRequest struct {
	Payload *ContainerArchiveLibpodBadRequestBody
}

// IsSuccess returns true when this container archive libpod bad request response has a 2xx status code
func (o *ContainerArchiveLibpodBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container archive libpod bad request response has a 3xx status code
func (o *ContainerArchiveLibpodBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container archive libpod bad request response has a 4xx status code
func (o *ContainerArchiveLibpodBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this container archive libpod bad request response has a 5xx status code
func (o *ContainerArchiveLibpodBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this container archive libpod bad request response a status code equal to that given
func (o *ContainerArchiveLibpodBadRequest) IsCode(code int) bool {
	return code == 400
}

func (o *ContainerArchiveLibpodBadRequest) Error() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/archive][%d] containerArchiveLibpodBadRequest  %+v", 400, o.Payload)
}

func (o *ContainerArchiveLibpodBadRequest) String() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/archive][%d] containerArchiveLibpodBadRequest  %+v", 400, o.Payload)
}

func (o *ContainerArchiveLibpodBadRequest) GetPayload() *ContainerArchiveLibpodBadRequestBody {
	return o.Payload
}

func (o *ContainerArchiveLibpodBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerArchiveLibpodBadRequestBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerArchiveLibpodNotFound creates a ContainerArchiveLibpodNotFound with default headers values
func NewContainerArchiveLibpodNotFound() *ContainerArchiveLibpodNotFound {
	return &ContainerArchiveLibpodNotFound{}
}

/*
ContainerArchiveLibpodNotFound describes a response with status code 404, with default header values.

No such container
*/
type ContainerArchiveLibpodNotFound struct {
	Payload *ContainerArchiveLibpodNotFoundBody
}

// IsSuccess returns true when this container archive libpod not found response has a 2xx status code
func (o *ContainerArchiveLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container archive libpod not found response has a 3xx status code
func (o *ContainerArchiveLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container archive libpod not found response has a 4xx status code
func (o *ContainerArchiveLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this container archive libpod not found response has a 5xx status code
func (o *ContainerArchiveLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this container archive libpod not found response a status code equal to that given
func (o *ContainerArchiveLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ContainerArchiveLibpodNotFound) Error() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/archive][%d] containerArchiveLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerArchiveLibpodNotFound) String() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/archive][%d] containerArchiveLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerArchiveLibpodNotFound) GetPayload() *ContainerArchiveLibpodNotFoundBody {
	return o.Payload
}

func (o *ContainerArchiveLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerArchiveLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerArchiveLibpodInternalServerError creates a ContainerArchiveLibpodInternalServerError with default headers values
func NewContainerArchiveLibpodInternalServerError() *ContainerArchiveLibpodInternalServerError {
	return &ContainerArchiveLibpodInternalServerError{}
}

/*
ContainerArchiveLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ContainerArchiveLibpodInternalServerError struct {
	Payload *ContainerArchiveLibpodInternalServerErrorBody
}

// IsSuccess returns true when this container archive libpod internal server error response has a 2xx status code
func (o *ContainerArchiveLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container archive libpod internal server error response has a 3xx status code
func (o *ContainerArchiveLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container archive libpod internal server error response has a 4xx status code
func (o *ContainerArchiveLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this container archive libpod internal server error response has a 5xx status code
func (o *ContainerArchiveLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this container archive libpod internal server error response a status code equal to that given
func (o *ContainerArchiveLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ContainerArchiveLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/archive][%d] containerArchiveLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerArchiveLibpodInternalServerError) String() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/archive][%d] containerArchiveLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerArchiveLibpodInternalServerError) GetPayload() *ContainerArchiveLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ContainerArchiveLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerArchiveLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ContainerArchiveLibpodBadRequestBody container archive libpod bad request body
swagger:model ContainerArchiveLibpodBadRequestBody
*/
type ContainerArchiveLibpodBadRequestBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container archive libpod bad request body
func (o *ContainerArchiveLibpodBadRequestBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container archive libpod bad request body based on context it is used
func (o *ContainerArchiveLibpodBadRequestBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerArchiveLibpodBadRequestBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerArchiveLibpodBadRequestBody) UnmarshalBinary(b []byte) error {
	var res ContainerArchiveLibpodBadRequestBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerArchiveLibpodInternalServerErrorBody container archive libpod internal server error body
swagger:model ContainerArchiveLibpodInternalServerErrorBody
*/
type ContainerArchiveLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container archive libpod internal server error body
func (o *ContainerArchiveLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container archive libpod internal server error body based on context it is used
func (o *ContainerArchiveLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerArchiveLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerArchiveLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ContainerArchiveLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerArchiveLibpodNotFoundBody container archive libpod not found body
swagger:model ContainerArchiveLibpodNotFoundBody
*/
type ContainerArchiveLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container archive libpod not found body
func (o *ContainerArchiveLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container archive libpod not found body based on context it is used
func (o *ContainerArchiveLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerArchiveLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerArchiveLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ContainerArchiveLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
