// Code generated by go-swagger; DO NOT EDIT.

package images_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewImageTagParams creates a new ImageTagParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewImageTagParams() *ImageTagParams {
	return &ImageTagParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewImageTagParamsWithTimeout creates a new ImageTagParams object
// with the ability to set a timeout on a request.
func NewImageTagParamsWithTimeout(timeout time.Duration) *ImageTagParams {
	return &ImageTagParams{
		timeout: timeout,
	}
}

// NewImageTagParamsWithContext creates a new ImageTagParams object
// with the ability to set a context for a request.
func NewImageTagParamsWithContext(ctx context.Context) *ImageTagParams {
	return &ImageTagParams{
		Context: ctx,
	}
}

// NewImageTagParamsWithHTTPClient creates a new ImageTagParams object
// with the ability to set a custom HTTPClient for a request.
func NewImageTagParamsWithHTTPClient(client *http.Client) *ImageTagParams {
	return &ImageTagParams{
		HTTPClient: client,
	}
}

/*
ImageTagParams contains all the parameters to send to the API endpoint

	for the image tag operation.

	Typically these are written to a http.Request.
*/
type ImageTagParams struct {

	/* Name.

	   the name or ID of the container
	*/
	Name string

	/* Repo.

	   the repository to tag in
	*/
	Repo *string

	/* Tag.

	   the name of the new tag
	*/
	Tag *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the image tag params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImageTagParams) WithDefaults() *ImageTagParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the image tag params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImageTagParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the image tag params
func (o *ImageTagParams) WithTimeout(timeout time.Duration) *ImageTagParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the image tag params
func (o *ImageTagParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the image tag params
func (o *ImageTagParams) WithContext(ctx context.Context) *ImageTagParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the image tag params
func (o *ImageTagParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the image tag params
func (o *ImageTagParams) WithHTTPClient(client *http.Client) *ImageTagParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the image tag params
func (o *ImageTagParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithName adds the name to the image tag params
func (o *ImageTagParams) WithName(name string) *ImageTagParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the image tag params
func (o *ImageTagParams) SetName(name string) {
	o.Name = name
}

// WithRepo adds the repo to the image tag params
func (o *ImageTagParams) WithRepo(repo *string) *ImageTagParams {
	o.SetRepo(repo)
	return o
}

// SetRepo adds the repo to the image tag params
func (o *ImageTagParams) SetRepo(repo *string) {
	o.Repo = repo
}

// WithTag adds the tag to the image tag params
func (o *ImageTagParams) WithTag(tag *string) *ImageTagParams {
	o.SetTag(tag)
	return o
}

// SetTag adds the tag to the image tag params
func (o *ImageTagParams) SetTag(tag *string) {
	o.Tag = tag
}

// WriteToRequest writes these params to a swagger request
func (o *ImageTagParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.Repo != nil {

		// query param repo
		var qrRepo string

		if o.Repo != nil {
			qrRepo = *o.Repo
		}
		qRepo := qrRepo
		if qRepo != "" {

			if err := r.SetQueryParam("repo", qRepo); err != nil {
				return err
			}
		}
	}

	if o.Tag != nil {

		// query param tag
		var qrTag string

		if o.Tag != nil {
			qrTag = *o.Tag
		}
		qTag := qrTag
		if qTag != "" {

			if err := r.SetQueryParam("tag", qTag); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
