// Code generated by go-swagger; DO NOT EDIT.

package system_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper-libpod/v4/models"
)

// SystemDataUsageReader is a Reader for the SystemDataUsage structure.
type SystemDataUsageReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SystemDataUsageReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSystemDataUsageOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 500:
		result := NewSystemDataUsageInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewSystemDataUsageOK creates a SystemDataUsageOK with default headers values
func NewSystemDataUsageOK() *SystemDataUsageOK {
	return &SystemDataUsageOK{}
}

/*
SystemDataUsageOK describes a response with status code 200, with default header values.

Disk usage
*/
type SystemDataUsageOK struct {
	Payload *SystemDataUsageOKBody
}

// IsSuccess returns true when this system data usage o k response has a 2xx status code
func (o *SystemDataUsageOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this system data usage o k response has a 3xx status code
func (o *SystemDataUsageOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this system data usage o k response has a 4xx status code
func (o *SystemDataUsageOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this system data usage o k response has a 5xx status code
func (o *SystemDataUsageOK) IsServerError() bool {
	return false
}

// IsCode returns true when this system data usage o k response a status code equal to that given
func (o *SystemDataUsageOK) IsCode(code int) bool {
	return code == 200
}

func (o *SystemDataUsageOK) Error() string {
	return fmt.Sprintf("[GET /system/df][%d] systemDataUsageOK  %+v", 200, o.Payload)
}

func (o *SystemDataUsageOK) String() string {
	return fmt.Sprintf("[GET /system/df][%d] systemDataUsageOK  %+v", 200, o.Payload)
}

func (o *SystemDataUsageOK) GetPayload() *SystemDataUsageOKBody {
	return o.Payload
}

func (o *SystemDataUsageOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(SystemDataUsageOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSystemDataUsageInternalServerError creates a SystemDataUsageInternalServerError with default headers values
func NewSystemDataUsageInternalServerError() *SystemDataUsageInternalServerError {
	return &SystemDataUsageInternalServerError{}
}

/*
SystemDataUsageInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type SystemDataUsageInternalServerError struct {
	Payload *SystemDataUsageInternalServerErrorBody
}

// IsSuccess returns true when this system data usage internal server error response has a 2xx status code
func (o *SystemDataUsageInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this system data usage internal server error response has a 3xx status code
func (o *SystemDataUsageInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this system data usage internal server error response has a 4xx status code
func (o *SystemDataUsageInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this system data usage internal server error response has a 5xx status code
func (o *SystemDataUsageInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this system data usage internal server error response a status code equal to that given
func (o *SystemDataUsageInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *SystemDataUsageInternalServerError) Error() string {
	return fmt.Sprintf("[GET /system/df][%d] systemDataUsageInternalServerError  %+v", 500, o.Payload)
}

func (o *SystemDataUsageInternalServerError) String() string {
	return fmt.Sprintf("[GET /system/df][%d] systemDataUsageInternalServerError  %+v", 500, o.Payload)
}

func (o *SystemDataUsageInternalServerError) GetPayload() *SystemDataUsageInternalServerErrorBody {
	return o.Payload
}

func (o *SystemDataUsageInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(SystemDataUsageInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SystemDataUsageInternalServerErrorBody system data usage internal server error body
swagger:model SystemDataUsageInternalServerErrorBody
*/
type SystemDataUsageInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this system data usage internal server error body
func (o *SystemDataUsageInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this system data usage internal server error body based on context it is used
func (o *SystemDataUsageInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *SystemDataUsageInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SystemDataUsageInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res SystemDataUsageInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SystemDataUsageOKBody system data usage o k body
swagger:model SystemDataUsageOKBody
*/
type SystemDataUsageOKBody struct {

	// containers
	Containers []*models.SystemDfContainerReport `json:"Containers"`

	// images
	Images []*models.SystemDfImageReport `json:"Images"`

	// volumes
	Volumes []*models.SystemDfVolumeReport `json:"Volumes"`
}

// Validate validates this system data usage o k body
func (o *SystemDataUsageOKBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateContainers(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateImages(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolumes(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SystemDataUsageOKBody) validateContainers(formats strfmt.Registry) error {
	if swag.IsZero(o.Containers) { // not required
		return nil
	}

	for i := 0; i < len(o.Containers); i++ {
		if swag.IsZero(o.Containers[i]) { // not required
			continue
		}

		if o.Containers[i] != nil {
			if err := o.Containers[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("systemDataUsageOK" + "." + "Containers" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("systemDataUsageOK" + "." + "Containers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SystemDataUsageOKBody) validateImages(formats strfmt.Registry) error {
	if swag.IsZero(o.Images) { // not required
		return nil
	}

	for i := 0; i < len(o.Images); i++ {
		if swag.IsZero(o.Images[i]) { // not required
			continue
		}

		if o.Images[i] != nil {
			if err := o.Images[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("systemDataUsageOK" + "." + "Images" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("systemDataUsageOK" + "." + "Images" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SystemDataUsageOKBody) validateVolumes(formats strfmt.Registry) error {
	if swag.IsZero(o.Volumes) { // not required
		return nil
	}

	for i := 0; i < len(o.Volumes); i++ {
		if swag.IsZero(o.Volumes[i]) { // not required
			continue
		}

		if o.Volumes[i] != nil {
			if err := o.Volumes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("systemDataUsageOK" + "." + "Volumes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("systemDataUsageOK" + "." + "Volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this system data usage o k body based on the context it is used
func (o *SystemDataUsageOKBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateContainers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateImages(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SystemDataUsageOKBody) contextValidateContainers(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Containers); i++ {

		if o.Containers[i] != nil {
			if err := o.Containers[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("systemDataUsageOK" + "." + "Containers" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("systemDataUsageOK" + "." + "Containers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SystemDataUsageOKBody) contextValidateImages(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Images); i++ {

		if o.Images[i] != nil {
			if err := o.Images[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("systemDataUsageOK" + "." + "Images" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("systemDataUsageOK" + "." + "Images" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SystemDataUsageOKBody) contextValidateVolumes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Volumes); i++ {

		if o.Volumes[i] != nil {
			if err := o.Volumes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("systemDataUsageOK" + "." + "Volumes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("systemDataUsageOK" + "." + "Volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SystemDataUsageOKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SystemDataUsageOKBody) UnmarshalBinary(b []byte) error {
	var res SystemDataUsageOKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
