// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// Config Config contains the configuration data about a container.
//
// It should hold only portable information about the container.
// Here, "portable" means "independent from the host we are running on".
// Non-portable information *should* appear in HostConfig.
// All fields added to this struct must be marked `omitempty` to keep getting
// predictable hashes from the old `v1Compatibility` configuration.
//
// swagger:model Config
type Config struct {

	// args escaped
	ArgsEscaped bool `json:"ArgsEscaped,omitempty"`

	// attach stderr
	AttachStderr bool `json:"AttachStderr,omitempty"`

	// attach stdin
	AttachStdin bool `json:"AttachStdin,omitempty"`

	// attach stdout
	AttachStdout bool `json:"AttachStdout,omitempty"`

	// cmd
	Cmd StrSlice `json:"Cmd,omitempty"`

	// domainname
	Domainname string `json:"Domainname,omitempty"`

	// entrypoint
	Entrypoint StrSlice `json:"Entrypoint,omitempty"`

	// env
	Env []string `json:"Env"`

	// exposed ports
	ExposedPorts PortSet `json:"ExposedPorts,omitempty"`

	// healthcheck
	Healthcheck *HealthConfig `json:"Healthcheck,omitempty"`

	// hostname
	Hostname string `json:"Hostname,omitempty"`

	// image
	Image string `json:"Image,omitempty"`

	// labels
	Labels map[string]string `json:"Labels,omitempty"`

	// mac address
	MacAddress string `json:"MacAddress,omitempty"`

	// network disabled
	NetworkDisabled bool `json:"NetworkDisabled,omitempty"`

	// on build
	OnBuild []string `json:"OnBuild"`

	// open stdin
	OpenStdin bool `json:"OpenStdin,omitempty"`

	// shell
	Shell StrSlice `json:"Shell,omitempty"`

	// stdin once
	StdinOnce bool `json:"StdinOnce,omitempty"`

	// stop signal
	StopSignal string `json:"StopSignal,omitempty"`

	// stop timeout
	StopTimeout int64 `json:"StopTimeout,omitempty"`

	// tty
	Tty bool `json:"Tty,omitempty"`

	// user
	User string `json:"User,omitempty"`

	// volumes
	Volumes map[string]interface{} `json:"Volumes,omitempty"`

	// working dir
	WorkingDir string `json:"WorkingDir,omitempty"`
}

// Validate validates this config
func (m *Config) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCmd(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEntrypoint(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExposedPorts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHealthcheck(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShell(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Config) validateCmd(formats strfmt.Registry) error {
	if swag.IsZero(m.Cmd) { // not required
		return nil
	}

	if err := m.Cmd.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("Cmd")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("Cmd")
		}
		return err
	}

	return nil
}

func (m *Config) validateEntrypoint(formats strfmt.Registry) error {
	if swag.IsZero(m.Entrypoint) { // not required
		return nil
	}

	if err := m.Entrypoint.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("Entrypoint")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("Entrypoint")
		}
		return err
	}

	return nil
}

func (m *Config) validateExposedPorts(formats strfmt.Registry) error {
	if swag.IsZero(m.ExposedPorts) { // not required
		return nil
	}

	if m.ExposedPorts != nil {
		if err := m.ExposedPorts.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ExposedPorts")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ExposedPorts")
			}
			return err
		}
	}

	return nil
}

func (m *Config) validateHealthcheck(formats strfmt.Registry) error {
	if swag.IsZero(m.Healthcheck) { // not required
		return nil
	}

	if m.Healthcheck != nil {
		if err := m.Healthcheck.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("Healthcheck")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("Healthcheck")
			}
			return err
		}
	}

	return nil
}

func (m *Config) validateShell(formats strfmt.Registry) error {
	if swag.IsZero(m.Shell) { // not required
		return nil
	}

	if err := m.Shell.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("Shell")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("Shell")
		}
		return err
	}

	return nil
}

// ContextValidate validate this config based on the context it is used
func (m *Config) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCmd(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEntrypoint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExposedPorts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHealthcheck(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateShell(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Config) contextValidateCmd(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Cmd.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("Cmd")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("Cmd")
		}
		return err
	}

	return nil
}

func (m *Config) contextValidateEntrypoint(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Entrypoint.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("Entrypoint")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("Entrypoint")
		}
		return err
	}

	return nil
}

func (m *Config) contextValidateExposedPorts(ctx context.Context, formats strfmt.Registry) error {

	if err := m.ExposedPorts.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("ExposedPorts")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("ExposedPorts")
		}
		return err
	}

	return nil
}

func (m *Config) contextValidateHealthcheck(ctx context.Context, formats strfmt.Registry) error {

	if m.Healthcheck != nil {
		if err := m.Healthcheck.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("Healthcheck")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("Healthcheck")
			}
			return err
		}
	}

	return nil
}

func (m *Config) contextValidateShell(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Shell.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("Shell")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("Shell")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Config) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Config) UnmarshalBinary(b []byte) error {
	var res Config
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
