/*
 * Decompiled with CFR 0.152.
 */
package it.javalinux.wise.core.client;

import it.javalinux.wise.core.client.InvocationResult;
import it.javalinux.wise.core.client.WSEndpoint;
import it.javalinux.wise.core.client.WebParameter;
import it.javalinux.wise.core.exceptions.WiseException;
import it.javalinux.wise.core.exceptions.WiseRuntimeException;
import it.javalinux.wise.core.mapper.WiseMapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jws.Oneway;
import javax.jws.WebParam;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class WSMethod {
    private Method method;
    private WSEndpoint endpoint;

    public WSMethod(Method method, WSEndpoint endpoint) {
        this.method = method;
        this.endpoint = endpoint;
    }

    InvocationResult invoke(Map<String, Object> args) throws WiseException {
        Method methodPointer = null;
        InvocationResult result = null;
        Map<String, Object> emptyHolder = Collections.emptyMap();
        if (args.values().size() == 1) {
            Object firstElement = args.values().iterator().next();
        }
        try {
            Object epInstance = this.getEndpoint().getInstance();
            methodPointer = epInstance.getClass().getMethod(this.getMethod().getName(), this.getMethod().getParameterTypes());
            result = this.isOneWay() ? new InvocationResult(null, null, emptyHolder) : new InvocationResult("result", methodPointer.invoke(epInstance, this.getParmeterInRightPositionArray(args)), this.getHoldersResult(args));
        }
        catch (InvocationTargetException ite) {
            System.out.print("error invoking:" + this.getMethod());
            System.out.print("error invoking:" + args.values().toArray());
            for (int i = 0; i < methodPointer.getExceptionTypes().length; ++i) {
                if (!ite.getCause().getClass().isAssignableFrom(methodPointer.getExceptionTypes()[i])) continue;
                result = new InvocationResult("exception", ite.getCause(), emptyHolder);
                return result;
            }
            WiseException.rethrow("Unknown exception received: " + ite.getMessage(), ite);
        }
        catch (Exception e) {
            WiseRuntimeException.rethrow("Error during method invocation!", e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvocationResult invoke(Object args, WiseMapper mapper) throws WiseException {
        if (mapper == null) {
            return this.invoke((Map)args);
        }
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            Map<String, Object> mappingResults;
            try {
                Thread.currentThread().setContextClassLoader(this.getEndpoint().getClassLoader());
                mappingResults = mapper.applyMapping(args);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
            return this.invoke(mappingResults);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WiseException("Transformation Failed");
        }
    }

    public synchronized Map<String, WebParameter> getWebParams() {
        HashMap<String, WebParameter> parameters = new HashMap<String, WebParameter>();
        Method method = this.getMethod();
        Annotation[][] annotations = method.getParameterAnnotations();
        Type[] methodparameterTypes = method.getGenericParameterTypes();
        block0: for (int i = 0; i < annotations.length; ++i) {
            for (int j = 0; j < annotations[i].length; ++j) {
                if (!(annotations[i][j] instanceof WebParam)) continue;
                WebParam webParaAnno = (WebParam)annotations[i][j];
                WebParameter parameter = new WebParameter(methodparameterTypes[i], webParaAnno.name(), i);
                parameter.setMode((Enum<WebParam.Mode>)webParaAnno.mode());
                parameters.put(parameter.getName(), parameter);
                continue block0;
            }
        }
        return parameters;
    }

    Object[] getParmeterInRightPositionArray(Map<String, Object> originalParams) {
        Object[] arrayToReturn = new Object[originalParams.size()];
        Map<String, WebParameter> webParams = this.getWebParams();
        for (String key : originalParams.keySet()) {
            if (webParams.get(key) == null) continue;
            WebParameter webPara = webParams.get(key);
            int position = webParams.get(key).getPosition();
            arrayToReturn[position] = originalParams.get(key);
        }
        return arrayToReturn;
    }

    public Map<String, Object> getHoldersResult(Map<String, Object> paras) {
        HashMap<String, Object> holders = new HashMap<String, Object>();
        Map<String, WebParameter> webParams = this.getWebParams();
        for (String key : paras.keySet()) {
            WebParameter wisePara = webParams.get(key);
            if (wisePara.getMode() != WebParam.Mode.INOUT && wisePara.getMode() != WebParam.Mode.OUT) continue;
            holders.put(key, paras.get(key));
        }
        return holders;
    }

    public synchronized boolean isOneWay() {
        return this.method.getAnnotation(Oneway.class) != null;
    }

    public synchronized Method getMethod() {
        return this.method;
    }

    public synchronized void setMethod(Method method) {
        this.method = method;
    }

    public synchronized WSEndpoint getEndpoint() {
        return this.endpoint;
    }

    public synchronized void setEndpoint(WSEndpoint endpoint) {
        this.endpoint = endpoint;
    }
}

