/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.message.format;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.message.format.serialized.JavaMessageSerializer;
import org.jboss.internal.soa.esb.message.format.xml.XMLMessageSerializer;
import org.jboss.soa.esb.message.Message;

public abstract class MessageSerializer {
    public static final byte PREAMBLE_XML = 0;
    public static final byte PREAMBLE_JAVA = 1;
    private static XMLMessageSerializer xmlSerializer = new XMLMessageSerializer();
    private static JavaMessageSerializer javaSerializer = new JavaMessageSerializer();

    public abstract void serialize(Message var1, OutputStream var2) throws IOException;

    public abstract Message deserialize(InputStream var1) throws IOException;

    public static byte[] serialize(Message message) throws IOException {
        ByteArrayOutputStream bytesOutStream = new ByteArrayOutputStream();
        MessageSerializer.serializeMessage(message, bytesOutStream);
        return bytesOutStream.toByteArray();
    }

    public static Message deserialize(byte[] messageBytes) throws IOException {
        ByteArrayInputStream bytesInStream = new ByteArrayInputStream(messageBytes);
        return MessageSerializer.deserializeMessage(bytesInStream);
    }

    public static void serializeMessage(Message message, OutputStream outStream) throws IOException {
        MessageSerializer serializer;
        AssertArgument.isNotNull(message, "message");
        AssertArgument.isNotNull(outStream, "outStream");
        if (XMLMessageSerializer.isXMLMessage(message)) {
            serializer = xmlSerializer;
        } else if (JavaMessageSerializer.isJavaMessage(message)) {
            serializer = javaSerializer;
        } else {
            throw new IOException("Unsupported Message implementation type '" + message.getClass().getName() + "'.");
        }
        ((MessageSerializer)serializer).serialize(message, outStream);
    }

    public static Message deserializeMessage(InputStream inStream) throws IOException {
        MessageSerializer serializer;
        AssertArgument.isNotNull(inStream, "inStream");
        if (!inStream.markSupported()) {
            throw new IOException("Cannot perform Message deserialization on supplied InputStream.  The InputStream must support mark and reset!");
        }
        inStream.mark(1);
        int preamble = inStream.read();
        inStream.reset();
        if (preamble == 0) {
            serializer = xmlSerializer;
        } else if (preamble == 1) {
            serializer = javaSerializer;
        } else {
            throw new IOException("Unsupported serialized Message format. Unrecognized message preamble.");
        }
        return ((MessageSerializer)serializer).deserialize(inStream);
    }
}

