/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.addressing.eprs;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.PortReference;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.w3c.dom.Element;

public class LogicalEPR
extends EPR {
    private static final String PROTOCOL = "logical";
    private ServiceInvoker serviceInvoker;
    private static URI _type;

    public LogicalEPR() {
    }

    public LogicalEPR(PortReference addr) {
        this(new EPR(addr));
    }

    public LogicalEPR(URI uri) {
        this(new EPR(uri));
    }

    public LogicalEPR(EPR epr) {
        super(epr);
        this.assertValidLogicalURI(URI.create(((PortReference)AssertArgument.isNotNull(epr.getAddr(), "addr")).getAddress()));
    }

    public LogicalEPR(EPR epr, Element header) {
        this(epr);
    }

    public LogicalEPR(String serviceCategory, String serviceName) {
        super(LogicalEPR.toLogicalURI(serviceCategory, serviceName));
    }

    public void setAddr(PortReference addr) {
        AssertArgument.isNotNull(addr, "addr");
        this.assertValidLogicalURI(URI.create(addr.getAddress()));
        super.setAddr(addr);
    }

    public Service toService() {
        URI uri;
        PortReference portRef = this.getAddr();
        if (portRef == null) {
            throw new IllegalStateException("Invalid Logical EPR state.  No PortReference set on EPR.");
        }
        try {
            uri = new URI(portRef.getAddress());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Invalid Logical EPR state.  '" + portRef.getAddress() + "' is not a valid URI.", e);
        }
        this.assertValidLogicalURI(uri);
        return new Service(uri.getSchemeSpecificPart(), uri.getFragment());
    }

    public ServiceInvoker getServiceInvoker() throws MessageDeliverException {
        if (this.serviceInvoker == null) {
            this.serviceInvoker = new ServiceInvoker(this.toService(), this.getAddr().getAllExtensions());
        }
        return this.serviceInvoker;
    }

    private static URI toLogicalURI(String serviceCategory, String serviceName) {
        AssertArgument.isNotNullAndNotEmpty(serviceCategory, "serviceCategory");
        AssertArgument.isNotNullAndNotEmpty(serviceName, "serviceName");
        try {
            return new URI(PROTOCOL, serviceCategory, serviceName);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void assertValidLogicalURI(URI uri) {
        if (!PROTOCOL.equalsIgnoreCase(uri.getScheme())) {
            throw new IllegalArgumentException("'" + uri + "' is not a valid URI for a Logical EPR - URI scheme must be '" + PROTOCOL + "'.");
        }
        if (!uri.isOpaque()) {
            throw new IllegalArgumentException("'" + uri + "' is not a valid URI for a Logical EPR - URI must be opaque.");
        }
        String category = uri.getSchemeSpecificPart();
        String name = uri.getFragment();
        if (category == null) {
            throw new IllegalArgumentException("'" + uri + "' is not a valid URI for a Logical EPR - no URI scheme specific part (service category).");
        }
        if (name == null) {
            throw new IllegalArgumentException("'" + uri + "' is not a valid URI for a Logical EPR - no URI fragment (service name) part.");
        }
    }

    public EPR copy() {
        return new LogicalEPR(this);
    }

    public static URI type() {
        return _type;
    }

    static {
        try {
            _type = new URI("urn:jboss/esb/epr/type/logical");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ExceptionInInitializerError(ex.toString());
        }
    }
}

