/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.project;

import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;

public class SaveProjectAsAction
extends AbstractAction {
    private final WsdlProject project;

    public SaveProjectAsAction(WsdlProject project) {
        super("Save Project As");
        this.project = project;
        this.putValue("ShortDescription", "Saves this project to a new file");
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu shift S"));
    }

    public void actionPerformed(ActionEvent e) {
        try {
            File file = UISupport.getFileDialogs().saveAs(this, "Select soapui project file", "xml", "XML", new File(this.project.getPath()));
            if (file == null) {
                return;
            }
            String fileName = file.getAbsolutePath();
            if (fileName == null) {
                return;
            }
            if (this.project.saveTo(fileName)) {
                this.project.getWorkspace().save(true);
            }
        }
        catch (IOException e1) {
            UISupport.showErrorMessage("Failed to save project; " + e1);
        }
    }
}

