/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.config.RequestAssertionConfig;
import com.eviware.soapui.impl.wsdl.panels.support.assertions.Assertable;
import com.eviware.soapui.impl.wsdl.submit.WsdlMessageExchange;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AssertionError;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AssertionException;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.WsdlAssertionRegistry;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.support.AbstractModelItem;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.apache.xmlbeans.XmlObject;

public abstract class WsdlMessageAssertion
extends AbstractModelItem {
    private RequestAssertionConfig assertionConfig;
    private final Assertable assertable;
    private Assertable.AssertionStatus assertionStatus = Assertable.AssertionStatus.UNKNOWN;
    private AssertionError[] assertionErrors;
    private ImageIcon validIcon;
    private ImageIcon failedIcon;
    private ImageIcon unknownIcon;
    public static final String STATUS_PROPERTY = WsdlMessageAssertion.class.getName() + "@status";
    public static final String CONFIGURATION_PROPERTY = WsdlMessageAssertion.class.getName() + "@configuration";

    public WsdlMessageAssertion(RequestAssertionConfig assertionConfig, Assertable modelItem) {
        this.assertionConfig = assertionConfig;
        this.assertable = modelItem;
        this.addAction(new RenameAssertionAction());
        this.addAction(new RemoveAssertionAction());
        if (this.isConfigurable()) {
            this.addAction(new ConfigureAssertionAction());
        }
        this.validIcon = UISupport.createImageIcon("/valid_assertion.gif");
        this.failedIcon = UISupport.createImageIcon("/failed_assertion.gif");
        this.unknownIcon = UISupport.createImageIcon("/unknown_assertion.gif");
    }

    protected XmlObject getConfiguration() {
        if (null == this.assertionConfig.getConfiguration()) {
            this.assertionConfig.addNewConfiguration();
        }
        return this.assertionConfig.getConfiguration();
    }

    protected void setConfiguration(XmlObject configuration) {
        XmlObject oldConfig = this.assertionConfig.getConfiguration();
        this.assertionConfig.setConfiguration(configuration);
        this.notifyPropertyChanged(CONFIGURATION_PROPERTY, oldConfig, configuration);
    }

    public String getName() {
        return this.assertionConfig.isSetName() ? this.assertionConfig.getName() : WsdlAssertionRegistry.getInstance().getAssertionNameForType(this.assertionConfig.getType());
    }

    public void setName(String name) {
        String old = this.getName();
        this.assertionConfig.setName(name);
        this.notifyPropertyChanged(NAME_PROPERTY, old, name);
    }

    public Assertable.AssertionStatus getStatus() {
        return this.assertionStatus;
    }

    public AssertionError[] getErrors() {
        return this.assertionErrors;
    }

    public Assertable.AssertionStatus assertResponse(WsdlMessageExchange messageExchange, SubmitContext context) {
        Assertable.AssertionStatus oldStatus = this.assertionStatus;
        ImageIcon oldIcon = this.getIcon();
        if (!messageExchange.hasResponse()) {
            if (messageExchange.getOperation().isOneWay()) {
                this.assertionStatus = Assertable.AssertionStatus.VALID;
                this.assertionErrors = null;
            } else {
                this.assertionStatus = Assertable.AssertionStatus.FAILED;
                this.assertionErrors = new AssertionError[]{new AssertionError("null/empty response")};
            }
        } else {
            try {
                this.internalAssertResponse(messageExchange, context);
                this.assertionStatus = Assertable.AssertionStatus.VALID;
                this.assertionErrors = null;
            }
            catch (AssertionException e) {
                this.assertionStatus = Assertable.AssertionStatus.FAILED;
                this.assertionErrors = e.getErrors();
            }
            catch (Throwable e) {
                this.assertionStatus = Assertable.AssertionStatus.FAILED;
                this.assertionErrors = new AssertionError[]{new AssertionError(e.getMessage())};
            }
        }
        this.notifyPropertyChanged(STATUS_PROPERTY, (Object)oldStatus, (Object)this.assertionStatus);
        this.notifyPropertyChanged(ICON_PROPERTY, oldIcon, this.getIcon());
        return this.assertionStatus;
    }

    protected abstract String internalAssertResponse(WsdlMessageExchange var1, SubmitContext var2) throws AssertionException;

    public Assertable.AssertionStatus assertRequest(WsdlMessageExchange messageExchange, SubmitContext context) {
        Assertable.AssertionStatus oldStatus = this.assertionStatus;
        ImageIcon oldIcon = this.getIcon();
        if (!messageExchange.hasRequest(true)) {
            this.assertionStatus = Assertable.AssertionStatus.FAILED;
            this.assertionErrors = new AssertionError[]{new AssertionError("null/empty response")};
        } else {
            try {
                this.internalAssertRequest(messageExchange, context);
                this.assertionStatus = Assertable.AssertionStatus.VALID;
                this.assertionErrors = null;
            }
            catch (AssertionException e) {
                this.assertionStatus = Assertable.AssertionStatus.FAILED;
                this.assertionErrors = e.getErrors();
            }
            catch (Throwable e) {
                this.assertionStatus = Assertable.AssertionStatus.FAILED;
                this.assertionErrors = new AssertionError[]{new AssertionError(e.getMessage())};
            }
        }
        this.notifyPropertyChanged(STATUS_PROPERTY, (Object)oldStatus, (Object)this.assertionStatus);
        this.notifyPropertyChanged(ICON_PROPERTY, oldIcon, this.getIcon());
        return this.assertionStatus;
    }

    protected abstract String internalAssertRequest(WsdlMessageExchange var1, SubmitContext var2) throws AssertionException;

    public boolean isConfigurable() {
        return false;
    }

    public boolean configure() {
        return true;
    }

    public ImageIcon getIcon() {
        switch (this.getStatus()) {
            case FAILED: {
                return this.failedIcon;
            }
            case UNKNOWN: {
                return this.unknownIcon;
            }
            case VALID: {
                return this.validIcon;
            }
        }
        return null;
    }

    public void updateConfig(RequestAssertionConfig config) {
        this.assertionConfig = config;
    }

    public Settings getSettings() {
        return this.assertable.getTestStep().getSettings();
    }

    public void release() {
    }

    public Assertable getAssertable() {
        return this.assertable;
    }

    public class ConfigureAssertionAction
    extends AbstractAction {
        public ConfigureAssertionAction() {
            super("Configure");
            this.putValue("ShortDescription", "Configures this assertion");
        }

        public void actionPerformed(ActionEvent e) {
            WsdlMessageAssertion.this.configure();
        }
    }

    public class RemoveAssertionAction
    extends AbstractAction {
        public RemoveAssertionAction() {
            super("Remove");
            this.putValue("ShortDescription", "Removes this assertion from its request");
        }

        public void actionPerformed(ActionEvent e) {
            if (UISupport.confirm("Remove assertion [" + WsdlMessageAssertion.this.getName() + "] from [" + WsdlMessageAssertion.this.assertable.getTestStep().getName() + "]", "Remove Assertion")) {
                WsdlMessageAssertion.this.assertable.removeAssertion(WsdlMessageAssertion.this);
            }
        }
    }

    public class RenameAssertionAction
    extends AbstractAction {
        public RenameAssertionAction() {
            super("Rename");
            this.putValue("ShortDescription", "Renames this assertion");
        }

        public void actionPerformed(ActionEvent e) {
            String name = UISupport.prompt("Specify name for this assertion", "Rename Assertion", WsdlMessageAssertion.this.getName());
            if (name == null || name.equals(WsdlMessageAssertion.this.getName())) {
                return;
            }
            WsdlMessageAssertion.this.setName(name);
        }
    }
}

