/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.AttachmentConfig;
import com.eviware.soapui.config.CallConfig;
import com.eviware.soapui.config.RequestAssertionConfig;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.WsdlSubmitContext;
import com.eviware.soapui.impl.wsdl.actions.request.DeleteRequestAction;
import com.eviware.soapui.impl.wsdl.actions.request.RenameRequestAction;
import com.eviware.soapui.impl.wsdl.panels.support.assertions.Assertable;
import com.eviware.soapui.impl.wsdl.panels.support.assertions.AssertionsListener;
import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlResponse;
import com.eviware.soapui.impl.wsdl.support.FileAttachment;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.AssertionsSupport;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlResponseMessageExchange;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.actions.AddAssertionAction;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.WsdlAssertionRegistry;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.monitor.TestMonitor;
import com.eviware.soapui.support.UISupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;

public class WsdlTestRequest
extends WsdlRequest
implements PropertyChangeListener,
Assertable {
    public static final String RESPONSE_PROPERTY = WsdlTestRequest.class.getName() + "@response";
    public static final String STATUS_PROPERTY = WsdlTestRequest.class.getName() + "@status";
    private ImageIcon validRequestIcon;
    private ImageIcon failedRequestIcon;
    private ImageIcon disabledRequestIcon;
    private ImageIcon unknownRequestIcon;
    private Assertable.AssertionStatus currentStatus;
    private final WsdlTestRequestStep testStep;
    private AssertionsSupport assertionsSupport;
    private WsdlResponseMessageExchange messageExchange;

    public WsdlTestRequest(WsdlOperation operation, CallConfig callConfig, WsdlTestRequestStep testStep) {
        super(operation, callConfig);
        this.setSettings(new XmlBeansSettingsImpl(this, testStep.getSettings(), callConfig.getSettings()));
        this.testStep = testStep;
        this.initAssertions();
        this.initIcons();
    }

    public WsdlTestCase getTestCase() {
        return this.testStep.getTestCase();
    }

    protected void initIcons() {
        this.validRequestIcon = UISupport.createImageIcon("/valid_request.gif");
        this.failedRequestIcon = UISupport.createImageIcon("/invalid_request.gif");
        this.unknownRequestIcon = UISupport.createImageIcon("/unknown_request.gif");
        this.disabledRequestIcon = UISupport.createImageIcon("/disabled_request.gif");
    }

    protected WsdlRequest.RequestIconAnimator initIconAnimator() {
        return new TestRequestIconAnimator();
    }

    protected void initActions() {
        this.addAction(new RenameRequestAction(this));
        this.addAction(new DeleteRequestAction(this));
        this.addAction(new AddAssertionAction(this));
    }

    private void initAssertions() {
        this.assertionsSupport = new AssertionsSupport(this, ((CallConfig)this.getConfig()).getAssertionList());
    }

    public int getAssertionCount() {
        return this.assertionsSupport.getAssertionCount();
    }

    public WsdlMessageAssertion getAssertionAt(int c) {
        return this.assertionsSupport.getAssertionAt(c);
    }

    public void setResponse(WsdlResponse response, SubmitContext context) {
        super.setResponse(response, context);
        this.assertResponse(context);
    }

    public void assertResponse(SubmitContext context) {
        PropertyChangeNotifier notifier = new PropertyChangeNotifier();
        this.messageExchange = new WsdlResponseMessageExchange(this);
        Iterator<WsdlMessageAssertion> iter = this.assertionsSupport.iterator();
        while (iter.hasNext()) {
            iter.next().assertResponse(this.messageExchange, context);
        }
        notifier.notifyChange();
    }

    public WsdlMessageAssertion addAssertion(String assertionLabel) {
        PropertyChangeNotifier notifier = new PropertyChangeNotifier();
        try {
            RequestAssertionConfig assertionConfig = ((CallConfig)this.getConfig()).addNewAssertion();
            assertionConfig.setType(WsdlAssertionRegistry.getInstance().getAssertionTypeForName(assertionLabel));
            WsdlMessageAssertion assertion = this.assertionsSupport.addWsdlAssertion(assertionConfig);
            this.assertionsSupport.fireAssertionAdded(assertion);
            if (this.getResponse() != null) {
                assertion.assertResponse(new WsdlResponseMessageExchange(this), new WsdlSubmitContext(this.testStep));
                notifier.notifyChange();
            }
            return assertion;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAssertion(WsdlMessageAssertion assertion) {
        PropertyChangeNotifier notifier = new PropertyChangeNotifier();
        try {
            int ix = this.assertionsSupport.removeAssertion(assertion);
            ((CallConfig)this.getConfig()).removeAssertion(ix);
        }
        finally {
            assertion.release();
            notifier.notifyChange();
        }
    }

    public Assertable.AssertionStatus getAssertionStatus() {
        this.currentStatus = Assertable.AssertionStatus.UNKNOWN;
        if (this.messageExchange != null) {
            if (!this.messageExchange.hasResponse() && !this.getOperation().isOneWay()) {
                this.currentStatus = Assertable.AssertionStatus.FAILED;
            }
        } else {
            return this.currentStatus;
        }
        int cnt = this.getAssertionCount();
        if (cnt == 0) {
            return this.currentStatus;
        }
        for (int c = 0; c < cnt; ++c) {
            if (this.getAssertionAt(c).getStatus() != Assertable.AssertionStatus.FAILED) continue;
            this.currentStatus = Assertable.AssertionStatus.FAILED;
            break;
        }
        if (this.currentStatus == Assertable.AssertionStatus.UNKNOWN) {
            this.currentStatus = Assertable.AssertionStatus.VALID;
        }
        return this.currentStatus;
    }

    public ImageIcon getIcon() {
        TestMonitor testMonitor = SoapUI.getTestMonitor();
        if (testMonitor != null && testMonitor.hasRunningLoadTest(this.testStep.getTestCase())) {
            return this.disabledRequestIcon;
        }
        ImageIcon icon = this.getIconAnimator().getIcon();
        if (icon == this.getIconAnimator().getBaseIcon()) {
            Assertable.AssertionStatus status = this.getAssertionStatus();
            if (status == Assertable.AssertionStatus.VALID) {
                return this.validRequestIcon;
            }
            if (status == Assertable.AssertionStatus.FAILED) {
                return this.failedRequestIcon;
            }
            if (status == Assertable.AssertionStatus.UNKNOWN) {
                return this.unknownRequestIcon;
            }
        }
        return icon;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(WsdlMessageAssertion.CONFIGURATION_PROPERTY)) {
            this.assertResponse(new WsdlSubmitContext(this.testStep));
        }
    }

    public void addAssertionsListener(AssertionsListener listener) {
        this.assertionsSupport.addAssertionsListener(listener);
    }

    public void removeAssertionsListener(AssertionsListener listener) {
        this.assertionsSupport.removeAssertionsListener(listener);
    }

    public void updateConfig(CallConfig request) {
        super.updateConfig(request);
        this.assertionsSupport.updateConfig(((CallConfig)this.getConfig()).getAssertionList());
        List attachmentConfigs = ((CallConfig)this.getConfig()).getAttachmentList();
        for (int i = 0; i < attachmentConfigs.size(); ++i) {
            AttachmentConfig config = (AttachmentConfig)attachmentConfigs.get(i);
            ((FileAttachment)this.attachments.get(i)).updateConfig(config);
        }
    }

    public void release() {
        super.release();
        this.assertionsSupport.release();
    }

    public String getAssertableContent() {
        return this.getResponse() == null ? null : this.getResponse().getContentAsString();
    }

    public WsdlTestRequestStep getTestStep() {
        return this.testStep;
    }

    public WsdlInterface getInterface() {
        return this.getOperation().getInterface();
    }

    public WsdlAssertionRegistry.AssertionType getAssertionType() {
        return WsdlAssertionRegistry.AssertionType.RESPONSE;
    }

    protected class TestRequestIconAnimator
    extends WsdlRequest.RequestIconAnimator {
        protected TestRequestIconAnimator() {
            super(WsdlTestRequest.this);
        }

        public boolean beforeSubmit(Submit submit, SubmitContext context) {
            if (SoapUI.getTestMonitor() != null && SoapUI.getTestMonitor().hasRunningLoadTest(WsdlTestRequest.this.getTestCase())) {
                return true;
            }
            return super.beforeSubmit(submit, context);
        }

        public void afterSubmit(Submit submit, SubmitContext context) {
            if (submit.getRequest() == this.getTarget()) {
                this.stop();
            }
        }
    }

    private class PropertyChangeNotifier {
        private Assertable.AssertionStatus oldStatus;
        private ImageIcon oldIcon;

        public PropertyChangeNotifier() {
            this.oldStatus = WsdlTestRequest.this.getAssertionStatus();
            this.oldIcon = WsdlTestRequest.this.getIcon();
        }

        public void notifyChange() {
            Assertable.AssertionStatus newStatus = WsdlTestRequest.this.getAssertionStatus();
            ImageIcon newIcon = WsdlTestRequest.this.getIcon();
            if (this.oldStatus != newStatus) {
                WsdlTestRequest.this.notifyPropertyChanged(STATUS_PROPERTY, (Object)this.oldStatus, (Object)newStatus);
            }
            if (this.oldIcon != newIcon) {
                WsdlTestRequest.this.notifyPropertyChanged(ModelItem.ICON_PROPERTY, this.oldIcon, WsdlTestRequest.this.getIcon());
            }
        }
    }
}

