/*
 * Copyright 2010 Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.jboss.soa.dsp;

import javax.xml.namespace.QName;

/**
 * Minimum endpoint meta data that's required to create
 * endpoints. Anything else is derived by the {@link org.jboss.soa.bpel.runtime.ws.EndpointManager}
 * itself.
 *
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class EndpointMetaData
{
  private QName serviceName;
  private String portName;
  private String endpointId;
  private QName processId;
  
  public EndpointMetaData(QName serviceName, String portName, QName processId, String endpointId)
  {
    this.serviceName = serviceName;
    this.portName = portName;
    this.processId = processId;
    this.endpointId = endpointId;
  }

  public QName getServiceName()
  {
    return serviceName;
  }

  public String getPortName()
  {
    return portName;
  }

  public QName getProcessId()
  {
    return processId;
  }

  public String getEndpointId()
  {
    return endpointId;
  }

  public void setEndpointId(String endpointId)
  {
    this.endpointId = endpointId;
  }
}
