package org.jboss.soa.bpel.samples.quickstart.account;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;

/**
 * published account functions
 */
@WebService(name = "AccountSystem", targetNamespace = "http://jbpm.org/examples/account")
@SOAPBinding(style = SOAPBinding.Style.RPC)
public interface AccountSystem {

	/**
	 * tell whether a customer has an active account
	 */
	@WebMethod(action = "http://jbpm.org/examples/account#verifyAccess")
	@WebResult(name = "granted", partName = "granted")
	public boolean checkAccess(
			@WebParam(name = "customerName", partName = "customerName") String customerName);

	/**
	 * retrieve the balance of an account
	 */
	@WebMethod(action = "http://jbpm.org/examples/account#queryBalance")
	@WebResult(name = "balance", partName = "balance")
	public double queryBalance(
			@WebParam(name = "customerName", partName = "customerName") String customerName);

	/**
	 * increase/decrease the balance of an account
	 */
	@WebMethod(action = "http://jbpm.org/examples/account#updateBalance")
	@WebResult(name = "balance", partName = "balance")
	public double updateBalance(
			@WebParam(name = "body", partName = "body") AccountOperation body);

}
