/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.samples.quickstart.purchase;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.jws.WebService;

/**
 * Production scheduling endpoint bean.
 * 
 * @author Alejandro Guizar
 */
@WebService(endpointInterface = "org.jboss.soa.bpel.samples.quickstart.purchase.SchedulingPT", targetNamespace = "http://manufacturing.org/wsdl/purchase", serviceName = "schedulingSVC", portName = "schedulingSP")
public class SchedulingPT_Impl implements SchedulingPT {

	private final Logger logger = Logger.getLogger(SchedulingPT.class.getName());

	public void requestProductionScheduling(CustomerInfo customerInfo,
			PurchaseOrder purchaseOrder) {
		logger.log(
				Level.FINE,
				"received production scheduling request for customer {0} and PO {1,number,integer}",
				new Object[] { customerInfo.getCustomerId(), purchaseOrder.getOrderId() });
	}

	public void sendShippingSchedule(ScheduleInfo schedule) {
		logger.log(Level.FINE, "received shipping schedule on {0,date}",
				schedule.getShipDate().toGregorianCalendar().getTime());
	}
}
