/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. 
 * See the copyright.txt in the distribution for a full listing 
 * of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU General Public License, v. 2.0.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License,
 * v. 2.0 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */
package org.jboss.internal.soa.esb.util.stax;

import java.net.URI;
import java.net.URISyntaxException;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;


/*
 * xs:anyURI
 */
/**
 * Representation of a URI
 * @author kevin
 */
public class URIElement extends ElementContent
{
    /**
     * The URI value of this element.
     */
    private URI value ;

    /**
     * Default constructor.
     */
    public URIElement()
    {
    }
    
    /**
     * Create the URI with a specific value.
     * @param value The URI value.
     */
    public URIElement(final URI value)
    {
        setValue(value) ;
    }
    
    /**
     * Construct the attributed uri from the input stream.
     * @param in The input stream.
     * @throws XMLStreamException for errors during reading.
     */
    public URIElement(final XMLStreamReader in)
        throws XMLStreamException
    {
        parse(in) ;
    }

    /**
     * Set the text value of this element.
     * @param in The current input stream.
     * @param value The text value.
     */
    protected void putValue(final XMLStreamReader in, final String value)
        throws XMLStreamException
    {
        final URI uriValue ;
        try
        {
            uriValue = new URI(value) ;
        }
        catch (final URISyntaxException urise)
        {
            throw new XMLStreamException("Failed to parse URI: " + value, urise) ;
        }
        setValue(uriValue) ;
    }
    
    /**
     * Set the URI value of this element.
     * @param value The URI value of the element.
     */
    public void setValue(final URI value)
    {
        this.value = value ;
    }
    
    /**
     * Get the URI value of this element.
     * @return The URI value of the element or null if not set.
     */
    public URI getValue()
    {
        return value ;
    }
    
    /**
     * Write the child content of the element.
     * @param out The output stream.
     */
    protected void writeChildContent(final XMLStreamWriter out)
        throws XMLStreamException
    {
        if (value != null)
        {
            out.writeCharacters(value.toString()) ;
        }
    }
    
    /**
     * Add the element.
     * @param in The current input stream.
     * @param elementName The qualified element name.
     */
    protected void putElement(final XMLStreamReader in,
        final QName elementName)
        throws XMLStreamException
    {
        // Ignore elements.
    }
    
    /**
     * Is the configuration of this element valid?
     * @return true if valid, false otherwise.
     */
    public boolean isValid()
    {
        return (value != null) && super.isValid() ;
    }
}
