/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.internal.soa.esb.util.stax.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.xml.stream.events.NotationDeclaration;

/**
 * Cached event information for NotationDeclaration.
 */
public class ESBStaxNotationDeclaration extends ESBStaxXMLEvent implements NotationDeclaration
{
    private final String name ;
    private final String publicId ;
    private final String systemId ;

    public ESBStaxNotationDeclaration(final NotationDeclaration notationDeclaration)
    {
        super(notationDeclaration) ;
        name = notationDeclaration.getName() ;
        publicId = notationDeclaration.getPublicId() ;
        systemId = notationDeclaration.getSystemId() ;
    }

    public String getName()
    {
        return name ;
    }

    public String getPublicId()
    {
        return publicId ;
    }

    public String getSystemId()
    {
        return systemId ;
    }

    static List<NotationDeclaration> getNotations(final List<NotationDeclaration> notations)
    {
        if (notations == null)
        {
            return null ;
        }
        else if (notations.size() > 0)
        {
            final List<NotationDeclaration> result = new ArrayList<NotationDeclaration>() ;
            for(NotationDeclaration notation: notations)
            {
                result.add(new ESBStaxNotationDeclaration(notation)) ;
            }
            return result ;
        }
        else
        {
            return Collections.emptyList() ;
        }
    }
}
