/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.internal.soa.esb.util.stax.events;

import java.util.Iterator;
import java.util.List;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;

/**
 * Cached event information for StartElement.
 */
public class ESBStaxStartElement extends ESBStaxXMLEvent implements StartElement
{
    private final QName name ;
    private final List<Attribute> attributes ;
    private final List<Namespace> namespaces ;
    private final NamespaceContext namespaceContext ;
    
    public ESBStaxStartElement(final StartElement startElement)
    {
        super(startElement) ;
        name = startElement.getName() ;
        attributes = ESBStaxAttribute.getAttributes(startElement.getAttributes()) ;
        namespaces = ESBStaxNamespace.getNamespaces(startElement.getNamespaces()) ;
        namespaceContext = ESBStaxNamespaceContext.getNamespaceContext(namespaces) ;
    }

    public Attribute getAttributeByName(final QName name)
    {
        for(Attribute attribute: attributes)
        {
            if (attribute.getName().equals(name))
            {
                return attribute ;
            }
        }
        return null ;
    }

    public Iterator<Attribute> getAttributes()
    {
        return attributes.iterator() ;
    }

    public QName getName()
    {
        return name ;
    }

    public NamespaceContext getNamespaceContext()
    {
        return namespaceContext ;
    }

    public String getNamespaceURI(final String prefix)
    {
        return namespaceContext.getNamespaceURI(prefix) ;
    }

    public Iterator getNamespaces()
    {
        return namespaces.iterator() ;
    }

    @Override
    public boolean isStartElement()
    {
        return true ;
    }

    @Override
    public StartElement asStartElement()
    {
        return this ;
    }
}
