/*
 * JBoss, Home of Professional Open Source
 * Copyright 2012, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2012,
 * @author JBoss Inc.
 */
package org.jboss.soa.esb.actions.aggregator;

import java.io.Serializable ;

/**
 * Aggregate details.
 * 
 * @author Kevin Conner
 */
public class AggregateDetails implements Serializable
{
    private static final long serialVersionUID = -7718553041580150082L ;
    
    public static final String AGGREGATE_DETAILS = "Aggregate.AggregateDetails" ;
    public static final String SERIES_UUID = "Aggregate.SeriesUUID" ;
    public static final String SEQUENCE_COUNT = "Aggregate.SequenceCount" ;
    
    private final String seriesUUID ;
    private final Integer messageSequence ;
    private Integer sequenceCount ;
    
    public AggregateDetails(final String seriesUUID, final Integer messageSequence)
    {
        this.seriesUUID = seriesUUID ;
        this.messageSequence = messageSequence ;
    }
    
    public String getSeriesUUID()
    {
        return seriesUUID ;
    }
    
    public Integer getMessageSequence()
    {
        return messageSequence ;
    }
    
    public void setSequenceCount(final Integer sequenceCount)
    {
        this.sequenceCount = sequenceCount ;
    }
    
    public Integer getSequenceCount()
    {
        return sequenceCount ;
    }
}