/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.http;

import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.Properties;

import java.util.regex.Pattern;

/**
 * HTTP Content Type utility methods.
 * 
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public abstract class HttpContentTypeUtil {

    private static Pattern[] textMimePatterns;

    static {
        String[] textTypes = ModulePropertyManager.getPropertyManager("core").getProperty("org.jboss.soa.esb.mime.text.types", "text/*;application/xml;application/*+xml").split(";");

        textMimePatterns = new Pattern[textTypes.length];
        for(int i = 0; i < textMimePatterns.length; i++) {
            String type = textTypes[i].trim().replace("*", ".*") ;
            type = type.replace("+", "\\+") ;
            textMimePatterns[i] = Pattern.compile(type);
        }
    }

    public static boolean isTextMimetype(String contentType) {
        if(contentType == null) {
            return false;
        }

        final int separator = contentType.indexOf(';') ;
        if (separator >= 0) {
            contentType = contentType.substring(0, separator) ;
        }
        for(int i = 0; i < textMimePatterns.length; i++) {
            if(textMimePatterns[i].matcher(contentType).matches()) {
                return true;
            }
        }

        return false;
    }
    
    public static String getContentType(final Message message) {
    	final HttpRequest request = HttpRequest.getRequest(message) ;
    	if (request != null)
    	{
    		return request.getContentType() ;
    	}
    	else
    	{
    		final Properties properties = message.getProperties() ;
    		final String[] names = properties.getNames() ;
    		for (String name: names)
    		{
    			final String normalized = name.toLowerCase() ;
    			if ("content-type".equals(normalized))
    			{
    				final Object property = properties.getProperty(name) ;
    				if (property instanceof String)
    				{
    					return (String)property ;
    				}
    			}
    		}
    		return null ;
    	}
    }
}