/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.gateway;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.event.AbstractEvent;
import org.hibernate.event.AutoFlushEvent;
import org.hibernate.event.AutoFlushEventListener;
import org.hibernate.event.DeleteEvent;
import org.hibernate.event.DeleteEventListener;
import org.hibernate.event.DirtyCheckEvent;
import org.hibernate.event.DirtyCheckEventListener;
import org.hibernate.event.EvictEvent;
import org.hibernate.event.EvictEventListener;
import org.hibernate.event.FlushEntityEvent;
import org.hibernate.event.FlushEntityEventListener;
import org.hibernate.event.FlushEvent;
import org.hibernate.event.FlushEventListener;
import org.hibernate.event.InitializeCollectionEvent;
import org.hibernate.event.InitializeCollectionEventListener;
import org.hibernate.event.LoadEvent;
import org.hibernate.event.LoadEventListener;
import org.hibernate.event.LockEvent;
import org.hibernate.event.LockEventListener;
import org.hibernate.event.MergeEvent;
import org.hibernate.event.MergeEventListener;
import org.hibernate.event.PersistEvent;
import org.hibernate.event.PersistEventListener;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostLoadEvent;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.event.PreDeleteEvent;
import org.hibernate.event.PreDeleteEventListener;
import org.hibernate.event.PreInsertEvent;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.event.PreLoadEvent;
import org.hibernate.event.PreLoadEventListener;
import org.hibernate.event.PreUpdateEvent;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.event.RefreshEvent;
import org.hibernate.event.RefreshEventListener;
import org.hibernate.event.ReplicateEvent;
import org.hibernate.event.ReplicateEventListener;
import org.hibernate.event.SaveOrUpdateEvent;
import org.hibernate.event.SaveOrUpdateEventListener;

/**
 * This class is a Hibernate EventListener which implements hooks to all the available
 * hibernate events.   It's not used at the moment, but might be a way of augmenting  
 * the Hibernate Interceptor hooks which are currently implemented.
 * 
 * Again, please note that this file is not currently used.
 * 
 * @author <a href="mailto:tcunning@redhat.com">tcunning@redhat.com</a>
 */
public class HibernateEventListener implements 
								AutoFlushEventListener,
								DeleteEventListener,
								DirtyCheckEventListener,
								EvictEventListener,
								FlushEntityEventListener,
								FlushEventListener,
								InitializeCollectionEventListener,
								LoadEventListener, 
								LockEventListener,
								MergeEventListener,
								PersistEventListener,
								PostDeleteEventListener,
								PostInsertEventListener,
								PostLoadEventListener,
								PostUpdateEventListener,
								PreDeleteEventListener,
								PreInsertEventListener,
								PreLoadEventListener,
								PreUpdateEventListener,
								RefreshEventListener,
								ReplicateEventListener,
								SaveOrUpdateEventListener {

	private static final long serialVersionUID = 7125882028251049616L;
	protected final static Logger m_logger = Logger.getLogger(HibernateEventListener.class);
	
	public HibernateEventListener() {
		super();

	}
	
	protected Object doPreSend() {
		try {
			return queue.take();
		} catch (InterruptedException e) {
			m_logger.warn(" interrupted while getting event off queue " , e);
			return null;
		}
	}

	protected BlockingQueue<AbstractEvent> queue = new LinkedBlockingQueue<AbstractEvent>();
	
	// Hibernate based event methods......
		
	public void onDelete(DeleteEvent event) throws HibernateException {
		System.out.println("HibernateEventLister!");

		if(m_logger.isDebugEnabled()) {
			m_logger.debug(" Receiving delete event: " + event);
		}
		try {
			queue.put(event);
		} catch (InterruptedException e) {
			m_logger.info(" Event was interrupted onDelete on adding to queue",e);
		}
	}

	public void onSaveOrUpdate(SaveOrUpdateEvent event) throws HibernateException {
		System.out.println("HibernateEventLister!");
		
		if(m_logger.isDebugEnabled()) {
			m_logger.debug(" Receiving save or update event: " + event);
		}
		try {
			queue.put(event);
		} catch (InterruptedException e) {
			m_logger.info(" Event was interrupted onSaveOrUpdate on adding to queue",e);
		}
	}

	public void onLoad(LoadEvent event, LoadType type) throws HibernateException {
		// TODO do something with the type : type.getName()
		System.out.println("HibernateEventLister!");

		if(m_logger.isDebugEnabled()) {
			m_logger.debug(" Receiving load event: " + event);
		}
		try {
			queue.put(event);
		} catch (InterruptedException e) {
			m_logger.info(" Event was interrupted onLoad on adding to queue",e);
		}
		
	}
	
	public void onDelete(DeleteEvent arg0, Set arg1) throws HibernateException {
		System.out.println("HibernateEventLister!");
		m_logger.error("onDelete");
	}
	
	public void onPostInsert (PostInsertEvent event) {
		System.out.println("HibernateEventLister!");
		m_logger.error("onPostInsert");
	}

	public void onDirtyCheck(DirtyCheckEvent arg0) throws HibernateException {
		System.out.println("HibernateEventLister!");
		m_logger.error("onDirtyCheck");
	}

	public void onEvict(EvictEvent arg0) throws HibernateException {
		System.out.println("HibernateEventLister!");
		m_logger.error("onEvict");
	}

	public void onFlushEntity(FlushEntityEvent arg0) throws HibernateException {
		System.out.println("HibernateEventLister!");
		m_logger.error("onFlushEntity");
	}

	public void onFlush(FlushEvent arg0) throws HibernateException {
		System.out.println("HibernateEventLister!");
		m_logger.error("onFlush");
	}

	public void onInitializeCollection(InitializeCollectionEvent arg0) throws HibernateException {
		System.out.println("HibernateEventLister!");
		m_logger.error("onEvict");
	}

	public void onLock(LockEvent arg0) throws HibernateException {
		System.out.println("HibernateEventLister!");
		m_logger.error("onLock");
	}

	public void onMerge(MergeEvent arg0) throws HibernateException {
		System.out.println("HibernateEventLister!");
		m_logger.error("onMerge");
	}

	public void onMerge(MergeEvent arg0, Map arg1) throws HibernateException {
		System.out.println("HibernateEventLister!");
		m_logger.error("onMerge");
	}

	public void onPersist(PersistEvent arg0) throws HibernateException {
		System.out.println("HibernateEventLister!");
		m_logger.error("onPersist");
	}

	public void onPersist(PersistEvent arg0, Map arg1) throws HibernateException {
		System.out.println("HibernateEventLister!");
		m_logger.error("onPersist");
	}

	public void onPostDelete(PostDeleteEvent arg0) {
		System.out.println("HibernateEventLister!");
		m_logger.error("onPostDelete");
	}

	public void onPostLoad(PostLoadEvent arg0) {
		System.out.println("HibernateEventLister!");
		m_logger.error("onPostLoad");
	}

	public void onPostUpdate(PostUpdateEvent arg0) {
		System.out.println("HibernateEventLister!");
		m_logger.error("onPostUpdate");
	}

	public boolean onPreDelete(PreDeleteEvent arg0) {
		System.out.println("HibernateEventLister!");
		m_logger.error("onPreDelete");
		return false;
	}

	public boolean onPreInsert(PreInsertEvent arg0) {
		System.out.println("HibernateEventLister!");
		m_logger.error("onPreInsert");
		return false;
	}

	public void onPreLoad(PreLoadEvent arg0) {
		System.out.println("HibernateEventLister!");
		m_logger.error("onPreLoad");
	}

	public boolean onPreUpdate(PreUpdateEvent arg0) {
		System.out.println("HibernateEventLister!");
		m_logger.error("onPreUpdate");
		return false;
	}

	public void onRefresh(RefreshEvent arg0) throws HibernateException {
		System.out.println("HibernateEventLister!");
		m_logger.error("onRefresh");
	}

	public void onRefresh(RefreshEvent arg0, Map arg1) throws HibernateException {
		System.out.println("HibernateEventLister!");
		m_logger.error("onRefresh");
	}

	public void onReplicate(ReplicateEvent arg0) throws HibernateException {
		System.out.println("HibernateEventLister!");
		m_logger.error("onReplicate");
	}

	public void onAutoFlush(AutoFlushEvent arg0) throws HibernateException {
		System.out.println("HibernateEventLister!");
		m_logger.error("onAutoFlush");
	}

}
