/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author derek.adams@sapience360.com
 */

package org.jboss.soa.esb.message.urigen;

import java.net.URI;

import org.jboss.soa.esb.message.Message;

/**
 * Interface for classes that generate URIs for messages.
 * 
 * @author Derek Adams
 */
public interface MessageURIGenerator {

	/**
	 * Generate a unique URI for a message.
	 * 
	 * @param message
	 * @return URI
	 */
	public URI generateMessageURI(Message message) throws URIGenerationException;
}