/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security.auth.ws;

import static org.jboss.soa.esb.services.security.auth.ws.SoapConstants.*;
import java.util.Iterator;

import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;

/**
 * Util class containing methods to help extract SOAP Security Headers
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 *
 */
public final class SOAPExtractorUtil
{
    private SOAPExtractorUtil()
    {
    }
    
    /**
     * Deprecated, please use {@link #extractSecurityHeader(SOAPEnvelope)} instead.
     */
    @Deprecated
    public static SOAPHeaderElement getSecurityHeader( final SOAPEnvelope env ) throws SOAPException 
    {
        return extractSecurityHeader(env);
    }
    
    /**
     * Will return the SOAP Security header from the passed in SOAPEnvelope if one exists.
     * 
     * @param env The SOAPEnvelope
     * @return SOAPHeaderElement The SOAP Security Header if one exists.
     * @throws SOAPException
     */
    public static SOAPHeaderElement extractSecurityHeader( final SOAPEnvelope env ) throws SOAPException 
    {
        if (env == null)
            return null;
        
        final SOAPHeader soapHeader = env.getHeader();
        if (soapHeader == null)
            return null;
            
        Iterator<?> headerElements = soapHeader.getChildElements(WSSE_QNAME);
        if (headerElements.hasNext())
            return (SOAPHeaderElement) headerElements.next();
        
        headerElements = soapHeader.getChildElements(WSSE_2_QNAME);
        if (headerElements.hasNext())
            return (SOAPHeaderElement) headerElements.next();
        
        headerElements = soapHeader.getChildElements(WSSE_11_QNAME);
        if (headerElements.hasNext())
            return (SOAPHeaderElement) headerElements.next();
            
        return null;
    }
    
}
