/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security.principals;

import java.io.Serializable;
import java.security.Principal;

/**
 * A Role is a collection/group of Principals.
 * <p/>
 * 
 * @author <a href="mailto:dbevenius@redhat.com">Daniel Bevenius</a>
 *
 */
public class Role implements Principal, Serializable
{
	private static final long serialVersionUID = 1L;
	private final String roleName;

	public Role(final String roleName)
	{
		if ( roleName == null )
			throw new NullPointerException("roleName argument must not be null");
		
		this.roleName = roleName;
	}

	public String getName()
	{
		return roleName;
	}
	
	public String toString()
	{
		return "[roleName=" + roleName + "]";
	}

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj)
			return true;
		if(!(obj instanceof Role))
			return false;
		
		Role other = (Role) obj; 
		return this.roleName.equals(other.roleName);
	}

	@Override
	public int hashCode()
	{
		int hash = 17;
		hash = 31 * hash + roleName == null ? 0 : roleName.hashCode();
		return hash;
	}

}
