/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.util;

import static org.junit.Assert.assertEquals;

import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipInputStream;

import junit.framework.JUnit4TestAdapter;

import org.jboss.soa.esb.util.JarUtil;
import org.junit.Test;

/**
 * Unit test for {@link JarUtil}
 * </p>
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 */
public class JarUtilUnitTest
{
    @Test
    public void test() throws IOException
    {
        ZipInputStream zipInputStream = new ZipInputStream(getClass().getResourceAsStream("jar-util-test.jar"));
        Map<String, String> filesMap = JarUtil.extractStringContents(".txt", zipInputStream);
        assertEquals(2, filesMap.size());
        assertEquals("Some text in textfile 1.", filesMap.get("testfile1.txt").trim());
        assertEquals("Some text in textfile 2.", filesMap.get("subdir/testfile2.txt").trim());
    }
    
    public static junit.framework.Test suite()
    {
        return new JUnit4TestAdapter(JarUtilUnitTest.class);
    }

}
