/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.tests.filter;

import java.net.URI;
import java.util.HashMap;

import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;

import org.jboss.soa.esb.addressing.eprs.FTPEpr;
import org.jboss.soa.esb.addressing.eprs.HTTPEpr;
import org.jboss.soa.esb.common.Environment;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.filter.FilterManager;
import org.jboss.soa.esb.listeners.ListenerTagNames;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.body.content.BytesBody;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.junit.BeforeClass;
import org.junit.Test;

import com.arjuna.common.util.propertyservice.PropertyManager;

public class ServiceRouteFilterUnitTest {
    @BeforeClass
    public static void setUp() throws Exception {
	    PropertyManager pm = ModulePropertyManager
		    .getPropertyManager(ModulePropertyManager.FILTER_MODULE);
	    pm.setProperty("org.jboss.soa.esb.filter.0",
		    "org.jboss.internal.soa.esb.message.filter.ServiceRouteFilter");
	    pm.setProperty(Environment.MESSAGE_TRACE, "on");
    }

    @Test
    public void testServiceRouting() throws Exception
    {
    	String gatewayConfig = "<listener acknowledge-mode=\"AUTO_ACKNOWLEDGE\" "
    		+ "busIdRef=\"quickstartGwChannel\" connection-factory=\"ConnectionFactory\" destination-name=\"queue/quickstart_helloworld_Request_gw\" "
    		+ "destination-type=\"queue\" gatewayClass=\"org.jboss.soa.esb.listeners.gateway.JmsGatewayListener\" is-gateway=\"true\" maxThreads=\"1\" "
    		+ "mep=\"OneWay\" name=\"JMS-Gateway\" persistent=\"true\" protocol=\"jms\" service-description=\"Hello World\" service-record-route=\"true\" "
    		+ "target-service-category=\"FirstServiceESB\" target-service-name=\"SimpleListener\" transacted=\"false\"/>";
    	HashMap map = new HashMap();
    	map.put("org.jboss.soa.esb.gateway.config", gatewayConfig);

    	Message msg = MessageFactory.getInstance().getMessage();
	    // Makes sure the message property is off
    	msg.getProperties().setProperty(ListenerTagNames.SERVICE_RECORD_ROUTE_TAG, "false");
	    msg.getHeader().getCall().setTo(new FTPEpr("ftp://foo.bar"));
	    msg.getHeader().getCall().setReplyTo(new HTTPEpr("http://bar.foo"));
	    msg.getHeader().getCall().setAction(new URI("urn:dowork"));
	    msg.getBody().add("Hello World".getBytes());
	    msg.getHeader().getCall().setMessageID(new URI("urn:foo/bar/1234"));

	    Message output = FilterManager.getInstance().doOutputWork(msg, map);
	    Assert.assertNotNull(output.getContext().getContext(Environment.MESSAGE_SERVICE_ROUTE));
    	
	    String falseGatewayConfig = gatewayConfig.replaceFirst("service-record-route=\"true\"",
	    		"service-record-route=\"false\"");
	    map.remove("org.jboss.soa.esb.gateway.config");
	    map.put("org.jboss.soa.esb.gateway.config", falseGatewayConfig);
	    Message input = FilterManager.getInstance().doInputWork(msg, map);
	    Assert.assertNotNull(input.getContext().getContext(Environment.MESSAGE_SERVICE_ROUTE));
	    
    }
    
    @Test
    public void testRouting() throws Exception
    {
    	String gatewayConfig = "<listener acknowledge-mode=\"AUTO_ACKNOWLEDGE\" "
    		+ "busIdRef=\"quickstartGwChannel\" connection-factory=\"ConnectionFactory\" destination-name=\"queue/quickstart_helloworld_Request_gw\" "
    		+ "destination-type=\"queue\" gatewayClass=\"org.jboss.soa.esb.listeners.gateway.JmsGatewayListener\" is-gateway=\"true\" maxThreads=\"1\" "
    		+ "mep=\"OneWay\" name=\"JMS-Gateway\" persistent=\"true\" protocol=\"jms\" service-description=\"Hello World\"  "
    		+ "target-service-category=\"FirstServiceESB\" target-service-name=\"SimpleListener\" transacted=\"false\"/>";
    	HashMap map = new HashMap();
    	map.put("org.jboss.soa.esb.gateway.config", gatewayConfig);
    	
    	Message msg = MessageFactory.getInstance().getMessage();
	    msg.getProperties().setProperty(ListenerTagNames.SERVICE_RECORD_ROUTE_TAG, "true");
	    msg.getHeader().getCall().setTo(new FTPEpr("ftp://foo.bar"));
	    msg.getHeader().getCall().setReplyTo(new HTTPEpr("http://bar.foo"));
	    msg.getHeader().getCall().setAction(new URI("urn:dowork"));
	    msg.getBody().add("Hello World".getBytes());
	    msg.getHeader().getCall().setMessageID(new URI("urn:foo/bar/1234"));

	    Message output = FilterManager.getInstance().doOutputWork(msg, map);
	    	
	    Assert.assertNotNull(output.getContext().getContext(Environment.MESSAGE_SERVICE_ROUTE));
	
	    msg.getContext().removeContext(Environment.MESSAGE_SERVICE_ROUTE);    
	    Message input = FilterManager.getInstance().doInputWork(msg, map);
	    Assert.assertNotNull(input.getContext().getContext(Environment.MESSAGE_SERVICE_ROUTE));
	    
	    msg.getContext().removeContext(Environment.MESSAGE_SERVICE_ROUTE);    
	    msg.getProperties().remove(ListenerTagNames.SERVICE_RECORD_ROUTE_TAG);
	    msg.getProperties().setProperty(ListenerTagNames.SERVICE_RECORD_ROUTE_TAG, "false");
	    input = FilterManager.getInstance().doInputWork(msg, map);
	    Assert.assertNull(input.getContext().getContext(Environment.MESSAGE_SERVICE_ROUTE));
	    
	    output = FilterManager.getInstance().doOutputWork(msg, map);
	    Assert.assertNull(output.getContext().getContext(Environment.MESSAGE_SERVICE_ROUTE));   
    }
    
}
	