/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.util;

import static org.junit.Assert.*;

import java.util.Properties;
import java.util.Set;

import org.jboss.soa.esb.addressing.eprs.JMSEpr;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.junit.Test;

/**
 * Unit test for {@link JndiUtil}.
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 */
public class JndiUtilUnitTest
{
    @Test
    public void getJndiPrefixesSet()
    {
        Set<String> set = JndiUtil.getJndiPrefixesSet("test.vendorName");
        assertEquals(3, set.size());
        assertTrue(set.contains("test.vendorName"));
        assertTrue(set.contains("java.naming."));
    }
    
    @Test
    public void getPropertyValue()
    {
        final ConfigTree config = new ConfigTree("config") ;
        config.setAttribute(JMSEpr.JNDI_PREFIXES, "test");
        String value = JndiUtil.getPropertyValue(config, JMSEpr.JNDI_PREFIXES);
        assertEquals("test", value);
    }
    
    @Test
    public void parseEnvironmentProperties()
    {
        final String envPrefix1 = "test.prefix.";
        final String envPrefix2 = "test.prefix2.";
        final String envPrefix = envPrefix1 + "," + envPrefix2;
        final String propertyName = envPrefix1 + "vendor.propertyName";
        final String propertyName2 = envPrefix2 + "propertyName2";
        final String propertyName3 = "java.naming.object";
        final String propertyValue = "propertyValue";
        final String propertyValue2 = "propertyValue2";
        final String propertyValue3 = "someValue";
        
        final ConfigTree config = new ConfigTree("config") ;
        config.setAttribute(JMSEpr.JNDI_PREFIXES, envPrefix);
        config.setAttribute(propertyName, propertyValue);
        config.setAttribute(propertyName2, propertyValue2);
        config.setAttribute("java.naming.object", "someValue");
        
        final Properties env = JndiUtil.parseEnvironmentProperties(config);
        
        assertEquals(3, env.size());
        assertTrue(env.containsKey(propertyName));
        assertTrue(env.containsKey(propertyName2));
        assertTrue(env.containsKey(propertyName3));
        assertEquals(propertyValue, env.get(propertyName));
        assertEquals(propertyValue2, env.get(propertyName2));
        assertEquals(propertyValue3, env.get(propertyName3));
    }

}
