/*
 * JBoss, Home of Professional Open Source
 * Copyright 2012, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2012,
 * @author JBoss Inc.
 */
package org.jboss.soa.esb.samples.quickstart.sampleaggregator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.UUID;

import org.apache.log4j.Logger;

import org.jboss.soa.esb.actions.aggregator.AggregateDetails;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageComposer;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;

public class IncomingComposer implements MessageComposer<File>
{
    private static final Logger LOGGER = Logger.getLogger(IncomingComposer.class) ;

    private Service service ;
    private ServiceInvoker serviceInvoker ;

    @Override
    public void setConfiguration(final ConfigTree config)
        throws ConfigurationException
    {
        service = Service.getGatewayTargetService(config) ;
        try
        {
            serviceInvoker = new ServiceInvoker(service) ;
        }
        catch (final MessageDeliverException mde)
        {
            throw new ConfigurationException("Unexpected exception while creating service invoker", mde.getCause()) ;
        }
    }

    @Override
    public Message compose(final File file)
        throws MessageDeliverException
    {
        final MessageFactory messageFactory = MessageFactory.getInstance() ;
        Message message = null ;

        int currentRecord = 0 ;
        final String seriesUUID = UUID.randomUUID().toString() ;
        LOGGER.info("Commence composition of series " + seriesUUID) ;

        try
        {
            final FileReader fr = new FileReader(file) ;
            try
            {
                final BufferedReader br = new BufferedReader(fr) ;
                do
                {
                    final String line = br.readLine() ;
                    if (line == null)
                    {
                        break ;
                    }
                    if (message != null)
                    {
                        serviceInvoker.deliverAsync(message) ;
                    }
                    message = messageFactory.getMessage() ;
                    message.getBody().add(line) ;
                    message.getProperties().setProperty(AggregateDetails.AGGREGATE_DETAILS, new AggregateDetails(seriesUUID, Integer.valueOf(currentRecord++))) ;
                }
                while(true) ;
                if (message != null)
                {
                    ((AggregateDetails)message.getProperties().getProperty(AggregateDetails.AGGREGATE_DETAILS)).setSequenceCount(Integer.valueOf(currentRecord)) ;
                }
            }
            finally
            {
                try
                {
                    fr.close() ;
                }
                catch (final IOException ioe) {} // ignore on close
                LOGGER.info("Finishing composition of series " + seriesUUID) ;
            }
        }
        catch (final IOException ioe)
        {
            throw new MessageDeliverException("Unexpected IO exception while processing " + file.getAbsolutePath(), ioe) ;
        }
        return message ;
    }

    @Override
    public Object decompose(final Message message, final File originalInputMessagePayload) throws MessageDeliverException
    {
        throw new MessageDeliverException("Not supported") ;
    }
}
